package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.StatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @author 即墨
 * Date 2021-07-19
 */
@Api(tags = {"店铺中心(F2B2b): 商家管理"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-ISellerExtApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/seller"
)
public interface ISellerExtApi {

    /**
     * 状态（启用、停用）
     */
    @PutMapping(value = "/status", produces = "application/json")
    @ApiOperation(value = "状态（启用 NORMAL、停用 BANNED）", notes = "状态（启用 NORMAL、停用 BANNED）")
    RestResponse<Void> changeStatus(@RequestBody @Valid StatusReqDto reqDto);


    /**
     * 开通商户
     *
     * @param sellerReqDto 开通商户信息封装对象
     * @return sellerId  商户ID
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "新增商户", notes = "{ \n" +
            "  \"companyName\": \"快乐有限公司\",\n" +
            "  \"name\": \"快乐有限商家\",\n" +
            "  \"organizationId\": 1209847065305195620,\n" +
            "  \"organizationName\": \"集团\"\n" +
            "}")
    RestResponse<Long> addSeller( @RequestBody SellerReqDto sellerReqDto);


    /**
     * 修改商户（修改商户）
     *
     * @param sellerReqDto 开通商户信息封装对象
     * @return void
     */
    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "修改商户", notes = "其他参数可以参考SellerToBReqDto,{\n" +
            "    \"id\": \"输入id\",\n" +
            "    \"status\": \"NORMAL正常 BANNED封禁\",\n" +
            "    \"name\": \"名称\"\n" +
            "}")
    RestResponse<Void> modifySeller(@RequestBody SellerToBReqDto sellerReqDto);

}
