package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author 即墨
 * Date 2021-07-22
 */
@Api(tags = {"店铺中心(F2B2b): 店铺管理"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-IShopExtApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/shop"
)
public interface IShopExtApi {

    /**
     * 状态（启用、停用）
     */
    @PutMapping(value = "/status", produces = "application/json")
    @ApiOperation(value = "状态（启用 NORMAL、停用 BANNED）", notes = "状态（启用 NORMAL、停用 BANNED")
    RestResponse<Void> changeStatus(@RequestBody @Valid StatusReqDto reqDto);

    /**
     * 新增店铺（开通店铺）
     *
     * @param shopDto   开通店铺信息（包括运营范围、经营区域、仓库信息）
     * @return 店铺ID
     */
    @PostMapping(value = "addShop", produces = "application/json")
    @ApiOperation(value = "新增店铺", notes = "{\n" +
            "\"collectionTypes\": \"SHOP_RECEIVE\",\n" +
            "\"name\": \"门店名称啦啦2啦1sumo\",\n" +
            "\"organizationId\": 1,\n" +
            "\"organizationName\": \"机构哈哈\",\n" +
            "\"sellerId\": 1281046438861906000,\n" +
            "\"shopIntroduction\": \"简介啦啦啦\",\n" +
            "\"shopWarehouseId\": \"1\",\n" +
            "\"warehouseId\": 1,\n" +
            "\"transportPartnerDtoList\": {\n" +
            "\"partnerCode\": \"0\",\n" +
            "\"partnerName\": \"商家自配\",\n" +
            "}\n" +
            "}")
    RestResponse<Long> addShop(@Valid @RequestBody ShopToBDto shopDto );
  /**
     * 编辑店铺
     *
     * @param shopDto   开通店铺信息（包括运营范围、经营区域、仓库信息）
     * @return 店铺ID
     */
    @PostMapping(value = "updateShop", produces = "application/json")
    @ApiOperation(value = " 编辑店铺", notes = "{\n" +
            "    \"collectionTypes\": \"SHOP_RECEIVE\",\n" +
            "    \"name\": \"门店名称啦啦啦\",\n" +
            "    \"organizationId\": 1,\n" +
            "    \"organizationName\": \"机构哈哈\",\n" +
            "    \"sellerId\": 1281046438861906000,\n" +
            "    \"shopWarehouseId\": \"仓库id\",\n" +
            "    \"shopIntroduction\": \"简介啦啦啦\",\n" +
            "    \"needAudit\": \"是否需要审核\",\n" +
            "    \"warehouseId\": 1000,\n" +
            "    \"transportPartnerDtoList\": {\n" +
            "        \"partnerCode\": \"0\",\n" +
            "        \"partnerName\": \"商家自配\"\n" +
            "    }\n" +
            "}")
    RestResponse<Long> updateShop(@Valid @RequestBody ShopToBDto shopDto );


    /**
     * 增加店铺运营范围与经营区域
     *
     * @param shopAreaAndRange 店铺运营范围信息
     * @return 运营范围ID
     */
    @PostMapping(value = "/business-scope", produces = "application/json")
    @ApiOperation(value = "增加/编辑店铺运营范围与经营区域", notes = "增加/编辑店铺运营范围与经营区域")
    RestResponse<Long> addShopBusinessScope(@Valid @RequestBody ShopAreaAndRangeReqDto shopAreaAndRange);

    /**
     * 提交-更新店铺和商家状态
     *
     */
    @PutMapping("/submit")
    @ApiOperation(value = "提交-更新门店和商家状态", notes = "提交-更新店铺和商家状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "shopId", value = "店铺ID", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "sellerId", value = "商家ID", dataType = "Long", paramType = "query")})
    RestResponse<Void> submit(@RequestParam("shopId") Long shopId,
                              @RequestParam(name = "sellerId", required = false) Long sellerId);


    @Deprecated
    @PostMapping("/checkShopSkuScope")
    @ApiOperation(value = "检查店铺sku是否可以上架售卖", notes = "检查店铺sku是否可以上架售卖")
    RestResponse<ShopToBItemRespDto> checkShopSkuScope(@RequestBody ShopToBItemReqDto shopToBItemReqDto);

}
