package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author 即墨
 * Date 2021-07-21
 */
public class BizBasicReqDto {

    @ApiModelProperty(value = "id")
    @NotNull(message = "id 不能为空")
    private Long id;

    @ApiModelProperty(value = "业务id")
    @NotNull(message = "业务id (businessId) 不能为空")
    private Long businessId;

    @ApiModelProperty(value = "业务类型: SELLER 商家  SHOP 店铺")
    @NotBlank(message = "业务类型（businessType） 不能为空")
    private String businessType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

}
