package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商家审核列表 查询对象
 * @author 即墨
 * Date 2021-07-20
 */
public class SellerAuditQueryReqDto extends BaseVo {

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，选填")
    private int pageNum = 1;

    @ApiModelProperty(value = "申请单号")
    private String applyCode;

    @ApiModelProperty(position = 0, value = "审核状态: WAIT_SUBMIT：待提交；PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝")
    private String status;

    @ApiModelProperty("商家编号")
    private String code;

    @ApiModelProperty("商家名称")
    private String mame;

    @ApiModelProperty("提交时间 - 起点")
    private String createTimeStart;

    @ApiModelProperty("提交时间 - 终点")
    private String createTimeEnd;


    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMame() {
        return mame;
    }

    public void setMame(String mame) {
        this.mame = mame;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

}
