package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author 即墨
 * Date 2021-07-20
 */
public class SellerToBQueryReqDto extends BaseVo {

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，选填")
    private int pageNum = 1;


    @ApiModelProperty("商家编号/名称")
    private String keyword;


    @ApiModelProperty(position = 0, value = "审核状态: DRAFT 待提交 PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝")
    private String status;

    @ApiModelProperty(value = "申请单号")
    private String applyCode;


    @ApiModelProperty("商家编号")
    private String code;

    @ApiModelProperty("商家名称")
    private String name;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("入驻时间 - 起点")
    private Date createTimeStart;

    @ApiModelProperty("入驻时间 - 终点")
    private Date createTimeEnd;


    @JsonIgnore
    private Long tenantId;

    @JsonIgnore
    private Long instanceId;

    @ApiModelProperty(name = "retailerOrgId", value = "零售商组织id")
    private Long retailerOrgId;

    @ApiModelProperty(name = "organizationIdList", value = "组织id集合")
    private List<Long> organizationIdList;

    @ApiModelProperty(name = "sellerDeadlineStart", value = "商家认证截至时间：开始时间")
    private Date sellerDeadlineStart;

    @ApiModelProperty(name = "sellerDeadlineEnd", value = "商家认证截至时间：结束时间")
    private Date sellerDeadlineEnd;

    @ApiModelProperty(name = "isFactoryDelivery", value = "是否厂家发货")
    private Integer isFactoryDelivery;

    public Long getRetailerOrgId() {
        return retailerOrgId;
    }

    public void setRetailerOrgId(Long retailerOrgId) {
        this.retailerOrgId = retailerOrgId;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Date getSellerDeadlineStart() {
        return sellerDeadlineStart;
    }

    public void setSellerDeadlineStart(Date sellerDeadlineStart) {
        this.sellerDeadlineStart = sellerDeadlineStart;
    }

    public Date getSellerDeadlineEnd() {
        return sellerDeadlineEnd;
    }

    public void setSellerDeadlineEnd(Date sellerDeadlineEnd) {
        this.sellerDeadlineEnd = sellerDeadlineEnd;
    }

    public Integer getIsFactoryDelivery() {
        return isFactoryDelivery;
    }

    public void setIsFactoryDelivery(Integer isFactoryDelivery) {
        this.isFactoryDelivery = isFactoryDelivery;
    }
}
