/**
 * @(#)ShopDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 店铺基本信息Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopAreaAndRangeReqDto", description = "店铺运营区域跟运营范围")
public class ShopAreaAndRangeReqDto extends BaseVo {


    @ApiModelProperty("运营范围")
    private List<ShopBusinessScopeDto> shopBusinessScopeDtos=new ArrayList<>();
    @ApiModelProperty("门店ID")
    private Long shopId;
    @ApiModelProperty("商家ID")
    private Long sellerId;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public List<ShopBusinessScopeDto> getShopBusinessScopeDtos() {
        return shopBusinessScopeDtos;
    }

    public void setShopBusinessScopeDtos(List<ShopBusinessScopeDto> shopBusinessScopeDtos) {
        this.shopBusinessScopeDtos = shopBusinessScopeDtos;
    }

    public Long getShopId() {

        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
