package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 店铺审核列表 查询对象
 * @author 即墨
 * Date 2021-07-20
 */
public class ShopAuditQueryReqDto extends BaseVo {

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，选填")
    private int pageNum = 1;


    @ApiModelProperty(position = 0, value = "审核状态: DRAFT：待提交；PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝")
    private String status;

    @ApiModelProperty(value = "申请单号")
    private String applyCode;

    @ApiModelProperty("店铺编号")
    private String code;

    @ApiModelProperty("店铺名称")
    private String name;

    @ApiModelProperty("商家名称")
    private String sellerName;

    @ApiModelProperty("提交时间 - 起点")
    private String createTimeStart;

    @ApiModelProperty("提交时间 - 终点")
    private String createTimeEnd;


    @JsonIgnore
    private Long tenantId;

    @JsonIgnore
    private Long instanceId;

    @ApiModelProperty(name = "organizationIdList", value = "组织id集合(商家对应的组织)")
    private List<Long> organizationIdList;

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
