/**
 * @(#)ShopDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 店铺基本信息Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopToBDto", description = "店铺信息Dto")
public class ShopToBDto extends BaseVo {

    @ApiModelProperty("门店id")
    private Long id;

    @ApiModelProperty(name = "transportPartnerDtoList", value = "配送方信息")
    private List<ShopTransportPartnerDto> transportPartnerDtoList;

    @ApiModelProperty(name = "name", value = "店铺名称，必填", required = true)
    @NotNull(message = "店铺名称不允许为空")
    private String name;

    @ApiModelProperty(name = "organizationId", value = "组织id", required = true)
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "shopIntroduction", value = "店铺简介，选填")
    private String shopIntroduction;

    @ApiModelProperty(name = "shopWarehouseId", value = "仓库ID", required = true)
    private List<Long> shopWarehouseIds
            ;
    @ApiModelProperty(name = "status", value = "状态，必填：NORMAL正常 BANNED封禁 CORRECTION整改")
    private String status;


    @ApiModelProperty("收款 方式(商家收款:SHOP_RECEIVE)")
    private String collectionTypes;
    @ApiModelProperty("商家Id")
    private Long sellerId;
    @ApiModelProperty("是否需要审核")
    private boolean needAudit;
    @ApiModelProperty("客户ID")
    private Long customerId;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isNeedAudit() {
        return needAudit;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ShopTransportPartnerDto> getTransportPartnerDtoList() {
        return transportPartnerDtoList;
    }

    public void setTransportPartnerDtoList(List<ShopTransportPartnerDto> transportPartnerDtoList) {
        this.transportPartnerDtoList = transportPartnerDtoList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }


    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public List<Long> getShopWarehouseIds() {
        return shopWarehouseIds;
    }

    public void setShopWarehouseIds(List<Long> shopWarehouseIds) {
        this.shopWarehouseIds = shopWarehouseIds;
    }

    public String getCollectionTypes() {
        return collectionTypes;
    }

    public void setCollectionTypes(String collectionTypes) {
        this.collectionTypes = collectionTypes;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public boolean getNeedAudit() {
        return needAudit;
    }

    public void setNeedAudit(boolean needAudit) {
        this.needAudit = needAudit;
    }
}
