/**
 * @(#)ShopDto.java 1.0 2018/9/3
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 店铺基本信息Dto
 *
 * @author 风信
 * @since 1.0.0
 */
@ApiModel(value = "ShopToBItemReqDto", description = "item信息Dto")
public class ShopToBItemReqDto extends BaseVo {

    @ApiModelProperty("商家id")
    private Long sellerId ;
    @ApiModelProperty("门店id")
    private Long shopId ;
    @ApiModelProperty("门店name")
    private String  shopName ;
    @ApiModelProperty("商品id")
    private Long itemId ;
    @ApiModelProperty("商品name")
    private String itemName ;

    @ApiModelProperty("skus")
    private List<ShopToBSkuDto> skus ;
    @ApiModelProperty("后端类目id")
    private Long dirId ;
    @ApiModelProperty("前台类目ids,逗号分隔")
    private String frontDirIds ;
    @ApiModelProperty("前台类目names,逗号分隔")
    private String frontDirNames ;

    @ApiModelProperty("后端类目name")
    private String dirName ;

    @ApiModelProperty("品牌id")
    private Long brandId ;
    @ApiModelProperty("品牌id")
    private String brandName ;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public List<ShopToBSkuDto> getSkus() {
        return skus;
    }

    public void setSkus(List<ShopToBSkuDto> skus) {
        this.skus = skus;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getFrontDirIds() {
        return frontDirIds;
    }

    public void setFrontDirIds(String frontDirIds) {
        this.frontDirIds = frontDirIds;
    }

    public String getFrontDirNames() {
        return frontDirNames;
    }

    public void setFrontDirNames(String frontDirNames) {
        this.frontDirNames = frontDirNames;
    }
}
