package com.dtyunxi.yundt.cube.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author 即墨
 * Date 2021-07-20
 */
public class ShopToBQueryReqDto extends BaseVo {

    /**
     * 每页页大小
     */
    @ApiModelProperty(name = "pageSize", value = "每页页大小，选填")
    private int pageSize = 10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，选填")
    private int pageNum = 1;


    @ApiModelProperty("店铺id")
    private Long sellerId;


    @ApiModelProperty("店铺编号")
    private String code;

    @ApiModelProperty("店铺名称")
    private String name;

    @ApiModelProperty("商家名称")
    private String sellerName;

    @ApiModelProperty("开店时间 - 起点")
    private Date createTimeStart;

    @ApiModelProperty("开店时间 - 终点")
    private Date createTimeEnd;

    @ApiModelProperty(value = "店铺状态（启用 NORMAL、停用 BANNED）")
    private String status;


    @JsonIgnore
    private Long tenantId;

    @JsonIgnore
    private Long instanceId;


    @ApiModelProperty("组织id(商家对应的组织)")
    private Long organizationId;
    private Long userId;

    @ApiModelProperty(name = "organizationIdList", value = "组织id集合(商家对应的组织)")
    private List<Long> organizationIdList;

    @ApiModelProperty(value = "商家状态（启用 NORMAL、停用 BANNED）")
    private String sellerStatus;

    public String getSellerStatus() {
        return sellerStatus;
    }

    public void setSellerStatus(String sellerStatus) {
        this.sellerStatus = sellerStatus;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }


    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
}
