package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerAuditListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAuditListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * @author 即墨
 * Date 2021-07-21
 */
@Api(tags = {"店铺中心(F2B2b): 审核"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-IAuditExtQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/audit"
)
public interface IAuditExtQueryApi {


    @GetMapping("/seller")
    @ApiOperation(value = "商家审核 - 列表", notes = "商家审核 - 列表")
    RestResponse<PageInfo<SellerAuditListRespDto>> querySellerAuditPage(@ModelAttribute SellerToBQueryReqDto reqDto);


    @GetMapping("/seller/{id}")
    @ApiOperation(value = "商家审核 - 详情", notes = "商家审核 - 列表")
    RestResponse<AuditRespDto<SellerToBReqDto>> querySellerAuditDetail(@PathVariable("id") Long id);


    @GetMapping("/shop")
    @ApiOperation(value = "店铺审核 - 列表", notes = "店铺审核 - 列表")
    RestResponse<PageInfo<ShopAuditListRespDto>> queryShopAuditPage(@ModelAttribute ShopAuditQueryReqDto reqDto);


    @GetMapping("/shop/{id}")
    @ApiOperation(value = "店铺审核 - 详情", notes = "店铺审核 - 详情")
    RestResponse<AuditRespDto<ShopToBDto>> queryShopAuditDetail(@PathVariable("id") Long id);

}
