package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 *
 * @author 即墨
 * Date 2021-07-19
 */
@Api(tags = {"店铺中心(F2B2b): 商家管理"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-ISellerExtQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/seller"
)
public interface ISellerExtQueryApi {

    @GetMapping("/area-group-tree")
    @ApiOperation(value = "销售区域 - 树形数据", notes = "销售区域 - 树形数据")
    RestResponse<List<AreaGroupRespDto>> queryAreaGroupTree(@RequestParam("orgId") String orgId);


    @GetMapping("")
    @ApiOperation(value = "商家列表", notes = "商家列表")
    RestResponse<PageInfo<SellerToBListRespDto>> queryPage(@ModelAttribute SellerToBQueryReqDto reqDto);


    @PostMapping("/queryPageByFeign")
    @ApiOperation(value = "商家列表", notes = "商家列表")
    RestResponse<PageInfo<SellerToBListRespDto>> queryPageByFeign(@RequestBody SellerToBQueryReqDto reqDto);

    /**
     * 根据组织ID查询商户信息
     *
     * @param organizationId 组织ID
     * @return {@linkplain com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto}
     */
    @GetMapping("/{organizationId}")
    @ApiOperation(value = "根据组织查询对应的商家信息", notes = "根据组织查询对应的商家信息")
    RestResponse<SellerRespDto> querySellerByOrganizationId(@NotNull(message = "商家客户ID不允许为空") @PathVariable("organizationId") Long organizationId);


    /**
     * 查询当前登录人的商户信息。（给品牌方使用）
     * 通过登录的机构id找到对应的商户id.
     * @return
     */
    @GetMapping("/query/bySession")
    @ApiOperation(value = "登录用户查询对应商家,品牌方使用", notes = "登录用户查询对应商家")
    RestResponse<SellerRespDto> querySellerBySession();

}
