package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBBaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBDropdownRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 店铺
 *
 * @author 即墨
 * Date 2021-07-21
 */
@Api(tags = {"店铺中心(F2B2b): 店铺管理"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-IShopExtQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/shop"
)
public interface IShopExtQueryApi {


    @GetMapping("")
    @ApiOperation(value = "店铺列表", notes = "店铺列表")
    RestResponse<PageInfo<ShopToBListRespDto>> queryPage(@ModelAttribute ShopToBQueryReqDto reqDto);


    @GetMapping("/current")
    @ApiOperation(value = "大B卖家端-店铺列表", notes = "大B卖家端 - 店铺列表")
    RestResponse<PageInfo<ShopToBListRespDto>> queryMyShopPage(@ModelAttribute ShopToBQueryReqDto reqDto);


    /**
     * 查询店铺基本信息
     *
     * @param shopId
     * @return
     */
    @GetMapping("/base/{shopId}")
    RestResponse<ShopDto> queryBaseById(@PathVariable("shopId") Long shopId);

   /**
     * 查出同属一个商家的其他店铺的可买范围并集
     *
     * @param shopId
     * @return
     */
    @GetMapping("/shopBusinessScope/{shopId}")
    @ApiOperation(value = "根据门店id查出同属一个商家的其他店铺的可买区域范围并集 ", notes = "查出同属一个商家的其他店铺的可买区域范围并集")
    RestResponse<List<ShopBusinessScopeDto>> queryShopBusinessScopeByShopId(@PathVariable("shopId") Long shopId);


    @GetMapping("/dropdown")
    @ApiOperation(value = "大B卖家端-我的店铺-下拉列表", notes = "大B卖家端-我的店铺-下拉列表")
    RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdown(@RequestParam(name = "userId", required = false) Long userId);

    @GetMapping("/dropdown/list")
    @ApiOperation(value = "店铺-下拉列表", notes = "店铺-下拉列表")
    RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdownBySellerId(@RequestParam(name = "sellerId", required = false) Long sellerId);

    @GetMapping("/list/by-userid")
    @ApiOperation(value = "根据用户查询店铺列表", notes = "根据用户查询店铺列表")
    RestResponse<List<ShopBaseDto>> queryShopListByUserId(@RequestParam(name = "userId") Long userId);

    @GetMapping("/list/by-orgid")
    @ApiOperation(value = "根据商家的组织Id查询店铺列表", notes = "根据商家的组织Id查询店铺列表")
    RestResponse<List<ShopBaseDto>> queryShopListBySellerOrgId(@RequestParam(name = "sellerOrgId") Long sellerOrgId);

    @GetMapping("/list/by-sellerid")
    @ApiOperation(value = "根据商家查询店铺列表", notes = "根据用户查询店铺列表")
    RestResponse<List<ShopBaseDto>> queryShopListBySellerId(@RequestParam(name = "sellerId") Long sellerId);

    /**
     * 根据店铺id集合查询店铺信息 包括禁用店铺、dr=1的
     *
     * @param shopIds 店铺id集合
     * @return 店铺基本信息集合
     */
    @GetMapping("/base/list")
    RestResponse<List<ShopToBBaseRespDto>> queryBaseByIdList(@RequestParam(name = "shopIdList", required = true) List<Long> shopIds);

}
