/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import cn.hutool.core.math.MathUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivitySimpleInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.CheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionValidTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IItemActivityPriceService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityPriceServiceImpl
implements IItemActivityPriceService {
    private static Logger logger = LoggerFactory.getLogger(ItemActivityPriceServiceImpl.class);
    private static final String ITEM_ACTIVITY_PRICE = "item_activity_price_";
    private static final String INDEX_TYPE_NAME = "item_price";
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IEngineApi engineApi;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private IActivityItemService activityItemService;
    @Resource
    private IActivityService activityService;
    @Resource
    private IActivityRelationService activityRelationService;
    @Resource
    private ActivityDas activityDas;

    @Override
    public void save(List<ItemActivityPriceDto> itemActivityPriceDtos) {
        Map<String, List<ItemActivityPriceDto>> group = itemActivityPriceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getItemId().toString()));
        group.values().forEach(priceDtos -> this.delete(((ItemActivityPriceDto)priceDtos.get(0)).getShopId(), ((ItemActivityPriceDto)priceDtos.get(0)).getItemId()));
        IndexDocumentVo doc = new IndexDocumentVo(this.getIndexName(), INDEX_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        itemActivityPriceDtos.forEach(priceDto -> {
            IndexDocContentVo docContentVo = new IndexDocContentVo();
            Long id = this.getIndexId();
            priceDto.setId(id);
            Map describe = CustomBeanUtils.describe((Object)priceDto);
            docContentVo.setDocValueMap(describe);
            docContentVo.setIndexId(id.toString());
            contents.add(docContentVo);
        });
        doc.setContents((List)contents);
        this.searchIndexService.addData(doc);
        logger.info("\u4fdd\u5b58\u5546\u54c1\u6d3b\u52a8\u4ef7\u683c\u6210\u529f\uff0c\u6570\u91cf={}", (Object)contents.size());
    }

    @Override
    public void delete(Long shopId, Long itemId) {
        logger.info("\u5220\u9664\u5546\u54c1\u6d3b\u52a8\u4ef7\u683cshopId={}, itemId={}", (Object)shopId, (Object)itemId);
        List<ItemActivityPriceDto> priceDtos = this.query(shopId, itemId);
        List indexIds = priceDtos.stream().map(priceDto -> String.valueOf(priceDto.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(indexIds)) {
            IndexDocumentVo doc = new IndexDocumentVo(this.getIndexName(), INDEX_TYPE_NAME);
            List contents = indexIds.stream().map(indexId -> {
                IndexDocContentVo contentVo = new IndexDocContentVo();
                contentVo.setIndexId(indexId);
                return contentVo;
            }).collect(Collectors.toList());
            doc.setContents(contents);
            this.searchIndexService.deleteData(doc);
        }
        logger.info("\u5220\u9664\u5546\u54c1\u6d3b\u52a8\u4ef7\u683cshopId={}, itemId={}\uff0c\u6570\u91cf={}", new Object[]{shopId, itemId, indexIds.size()});
    }

    @Override
    public List<ItemActivityPriceDto> query(Long shopId, Long itemId) {
        ItemActivityPriceQueryReqDto queryReqDto = new ItemActivityPriceQueryReqDto();
        queryReqDto.setShopId(shopId);
        queryReqDto.setItemId(itemId);
        return this.query(queryReqDto);
    }

    @Override
    public List<ItemActivityPriceDto> query(ItemActivityPriceQueryReqDto queryReqDto) {
        return this.queryList(queryReqDto);
    }

    @Override
    public void arrangement(ActivityItemDto activityItemDto, List<Long> activityIds) {
        logger.info("\u8ba1\u7b97\u5546\u54c1\u6d3b\u52a8\u6700\u4f4e\u4ef7\u683cshopId={},itemId={}, activityIds={}", new Object[]{activityItemDto.getShopId(), activityItemDto.getItemId(), JSON.toJSONString(activityIds)});
        String[] activityArr = activityIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[activityIds.size()]);
        List<String[]> arrange = this.calcMutex(activityArr);
        HashMap<String, EngineParams> resultMap = new HashMap<String, EngineParams>();
        List<ItemVo> itemVos = this.getItemVos(activityItemDto.getShopId(), activityItemDto.getItemId());
        EngineParams bestResult = this.calcPrice(resultMap, itemVos, arrange);
        ArrayList priceDtos = Lists.newArrayList();
        String activityIdStr = StringUtils.join((Iterable)bestResult.getActivityIds(), (String)"");
        itemVos.forEach(itemVo -> {
            String skuResultKey = itemVo.getSkuId() + activityIdStr;
            EngineParams calcResult = (EngineParams)resultMap.get(skuResultKey);
            if (null != calcResult) {
                List<ItemActivityPriceDto> priceDtoList = this.convert2ActivityPriceDtos(calcResult);
                priceDtos.addAll(priceDtoList);
            }
        });
        this.save(priceDtos);
    }

    private EngineParams calcPrice(Map<String, EngineParams> resultMap, List<ItemVo> itemVos, List<String[]> activityIds) {
        EngineParams bestResult = null;
        BigDecimal minPrice = null;
        ItemVo item = null;
        for (ItemVo itemVo : itemVos) {
            for (Object[] objectArray : activityIds) {
                item = new ItemVo();
                CubeBeanUtils.copyProperties((Object)item, (Object)itemVo, (String[])new String[0]);
                List ids = Arrays.asList(objectArray).stream().map(Long::new).collect(Collectors.toList());
                EngineParams params = new EngineParams();
                params.setUserId(1L);
                params.setValidType(ConditionValidTypeEnum.NO_THROW_EXCEPTION.getType());
                params.setActivityIds(ids);
                params.setItems((List)Lists.newArrayList((Object[])new ItemVo[]{item}));
                params.setIfValidActivityStatus(Boolean.valueOf(false));
                params.setPopulationFlag(Boolean.valueOf(false));
                params.setActivityStockFlag(Boolean.valueOf(false));
                EngineParams result = (EngineParams)this.engineApi.execute(CheckPointEnum.REVIEW_ACTIVITY.name(), params).getData();
                if (CollectionUtils.isEmpty((Collection)result.getActivityIds())) continue;
                BigDecimal currentMinPrice = result.getItems().stream().map(ItemVo::getPrice).sorted().findFirst().get();
                if (null == minPrice) {
                    minPrice = currentMinPrice;
                    bestResult = result;
                } else if (currentMinPrice.compareTo(minPrice) == -1) {
                    minPrice = currentMinPrice;
                    bestResult = result;
                } else if (currentMinPrice.compareTo(minPrice) == 0 && this.isAfter((Long)result.getActivityIds().get(0), (Long)bestResult.getActivityIds().get(0))) {
                    minPrice = currentMinPrice;
                    bestResult = result;
                }
                String resultKey = itemVo.getSkuId() + StringUtils.join((Object[])objectArray, (String)"");
                resultMap.put(resultKey, result);
            }
        }
        return bestResult;
    }

    private boolean isAfter(Long activityId, Long tragetActivityId) {
        ActivityRespDto one = this.activityService.queryById(activityId);
        ActivityRespDto two = this.activityService.queryById(tragetActivityId);
        return one.getCreateTime().after(two.getCreateTime());
    }

    private List<String[]> calcMutex(String[] activityArr) {
        ArrayList<String[]> allArrange = new ArrayList<String[]>();
        ArrayList mutexIds = Lists.newArrayList();
        for (int i = 1; i <= activityArr.length; ++i) {
            List arrange = MathUtil.arrangementSelect((String[])activityArr, (int)i);
            if (i > 1) {
                Iterator it = arrange.iterator();
                while (it.hasNext()) {
                    String[] arr = (String[])it.next();
                    if (i == 2) {
                        Long second;
                        Long first = Long.valueOf(arr[0]);
                        if (this.activityRelationService.newOverlap(first, second = Long.valueOf(arr[1]))) continue;
                        mutexIds.add(arr);
                        it.remove();
                        continue;
                    }
                    block2: for (String ids : arr) {
                        for (String[] mutexArr : mutexIds) {
                            boolean containFirst = false;
                            boolean containSecond = false;
                            if (ids.equals(mutexArr[0])) {
                                containFirst = true;
                            }
                            if (ids.equals(mutexArr[1])) {
                                containSecond = true;
                            }
                            if (!containFirst || !containSecond) continue;
                            it.remove();
                            continue block2;
                        }
                    }
                }
            }
            allArrange.addAll(arrange);
        }
        return allArrange;
    }

    public static void main(String[] args) {
        String[] activityArr = new String[]{"a", "b", "c"};
        List arrangement = MathUtil.arrangementSelect((String[])activityArr, (int)2);
        System.out.println(arrangement);
    }

    private List<ItemVo> getItemVos(Long shopId, Long itemId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1000)).getData();
        List<Object> itemVos = new ArrayList<ItemVo>();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            itemVos = pageInfo.getList().stream().map(itemShelfRespDto -> {
                ItemVo itemVo = new ItemVo();
                itemVo.setShopId(shopId.toString());
                itemVo.setItemId(itemId.toString());
                itemVo.setSkuId(itemShelfRespDto.getSkuId().toString());
                itemVo.setPrice(itemShelfRespDto.getPrice());
                itemVo.setOrigPrice(itemShelfRespDto.getPrice());
                itemVo.setNum(1);
                return itemVo;
            }).collect(Collectors.toList());
        }
        return itemVos;
    }

    private List<ItemActivityPriceDto> convert2ActivityPriceDtos(EngineParams params) {
        ArrayList<ItemActivityPriceDto> priceDtos = new ArrayList<ItemActivityPriceDto>();
        params.getItems().forEach(itemVo -> {
            ItemActivityPriceDto priceDto = new ItemActivityPriceDto();
            priceDto.setShopId(Long.valueOf(itemVo.getShopId()));
            priceDto.setItemId(Long.valueOf(itemVo.getItemId()));
            priceDto.setSkuId(Long.valueOf(itemVo.getSkuId()));
            priceDto.setPrice(itemVo.getPrice());
            priceDto.setType(Integer.valueOf(1));
            ArrayList activityList = new ArrayList();
            params.getActivityIds().forEach(activityId -> {
                ActivitySimpleInfoDto simpleInfoDto = new ActivitySimpleInfoDto();
                simpleInfoDto.setActivityId(activityId);
                ActivityRespDto activityRespDto = this.activityService.queryById((Long)activityId);
                if (null != activityRespDto) {
                    simpleInfoDto.setActivityTemplateId(activityRespDto.getActivityTemplateId());
                    simpleInfoDto.setActivityTag(activityRespDto.getTag());
                }
                activityList.add(simpleInfoDto);
            });
            priceDto.setActivityList(activityList);
            priceDtos.add(priceDto);
        });
        return priceDtos;
    }

    @Override
    public void arrangement(ActivityItemDto activityItemDto) {
        logger.info("\u8ba1\u7b97\u5546\u54c1\u6d3b\u52a8\u4ef7\u683cactivityItemDto={}", (Object)JSON.toJSONString((Object)activityItemDto));
        ActivityItemQueryReqDto dto = new ActivityItemQueryReqDto();
        dto.setShopId(activityItemDto.getShopId());
        dto.setItemId(activityItemDto.getItemId());
        List<ActivityItemRespDto> activityItems = this.activityItemService.queryActivityItem(dto);
        if (CollectionUtils.isEmpty(activityItems)) {
            logger.info("itemId={},shopId={}\u65e0\u6d3b\u52a8\u5546\u54c1\u6570\u636e", (Object)activityItemDto.getItemId(), (Object)activityItemDto.getShopId());
            return;
        }
        List<Long> activityIds = activityItems.stream().map(ActivityItemRespDto::getActivityId).collect(Collectors.toList());
        if (Objects.nonNull(activityItemDto.getActivityId())) {
            activityIds.add(activityItemDto.getActivityId());
        }
        ArrayList templateIds = Lists.newArrayList((Object[])new Long[]{ActivityType.SECKILL_ACTIVITY.getId(), ActivityType.GROUP_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.SECKILL_TOB_ACTIVITY.getId()});
        List<Long> enableIds = this.activityService.queryByIds(activityIds, Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey(), ActivityStatusEnum.READY.getKey()}), templateIds);
        if (CollectionUtils.isEmpty(enableIds)) {
            logger.info("\u5546\u54c1\u6ca1\u6709\u53ef\u7528\u7684\u6d3b\u52a8\uff0c\u4e0d\u9700\u8981\u8ba1\u7b97,itemId={},shopId={}", (Object)activityItemDto.getItemId(), (Object)activityItemDto.getShopId());
            return;
        }
        logger.info("itemId={}, shopId={},\u6d3b\u52a8\u6570\u91cf\uff1a{}", new Object[]{activityItemDto.getItemId(), activityItemDto.getShopId(), enableIds.size()});
        this.arrangement(activityItemDto, enableIds);
    }

    @Override
    public void arrangement(Long activityId) {
        logger.info("\u6839\u636e\u6d3b\u52a8id\u8ba1\u7b97\u5546\u54c1\u6d3b\u52a8\u4ef7\u683cactivityId={}", (Object)activityId);
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        if (!ActivityDimensionEnum.ITEM.getKey().equals(activityRespDto.getActivityTemplate().getDimension())) {
            logger.info("\u6d3b\u52a8activityId={}\u975e\u5546\u54c1\u7ef4\u5ea6\u6d3b\u52a8\uff0c\u4e0d\u9700\u8981\u8ba1\u7b97\u5546\u54c1\u6700\u4f4e\u6d3b\u52a8\u4ef7\u683c", (Object)activityId);
            return;
        }
        List<ActivityItemEo> itemEos = this.activityItemService.queryActivityByActivityId(activityId);
        List<Object> itemDtos = itemEos.stream().map(activityItemEo -> new ActivityItemDto(activityItemEo.getShopId(), activityItemEo.getItemId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemDtos)) {
            itemDtos = this.itemActivityTagService.getActivityItems(activityId);
            itemDtos.forEach(e -> e.setActivityId(activityId));
        }
        itemDtos.forEach(this::arrangement);
    }

    @Override
    public void delete(Long activityId) {
        logger.info("\u6839\u636e\u6d3b\u52a8id\u5220\u9664\u5546\u54c1\u6d3b\u52a8\u4ef7\u683cactivityId={}", (Object)activityId);
        ActivityRespDto activityRespDto = this.activityService.getById(activityId);
        if (!ActivityDimensionEnum.ITEM.getKey().equals(activityRespDto.getActivityTemplate().getDimension())) {
            logger.info("\u6d3b\u52a8activityId={}\u975e\u5546\u54c1\u7ef4\u5ea6\u6d3b\u52a8\uff0c\u4e0d\u9700\u8981\u5220\u9664\u5546\u54c1\u6d3b\u52a8\u4ef7\u683c", (Object)activityId);
            return;
        }
        List<ActivityItemEo> itemEos = this.activityItemService.queryActivityByActivityId(activityId);
        if (CollectionUtils.isEmpty(itemEos)) {
            List<ActivityItemDto> itemDtos = this.itemActivityTagService.getActivityItems(activityId);
            itemEos = new ArrayList<ActivityItemEo>(itemDtos.size());
            CubeBeanUtils.copyCollection(itemEos, itemDtos, ActivityItemEo.class);
        }
        Map<String, List<ActivityItemEo>> group = itemEos.stream().collect(Collectors.groupingBy(itemEo -> String.valueOf(itemEo.getShopId()) + itemEo.getItemId()));
        group.values().forEach(activityItemEos -> this.delete(((ActivityItemEo)activityItemEos.get(0)).getShopId(), ((ActivityItemEo)activityItemEos.get(0)).getItemId()));
    }

    @Override
    public List<ItemActivityPriceDto> queryList(ItemActivityPriceQueryReqDto queryReqDto) {
        SearchResultVo searchResultVo;
        OSSearchVo searchVo = new OSSearchVo();
        searchVo.setIndexName(this.getIndexName());
        searchVo.setTypeName(INDEX_TYPE_NAME);
        if (null != queryReqDto.getShopId()) {
            searchVo.addEqualFilter("shopId", queryReqDto.getShopId().toString());
        }
        if (null != queryReqDto.getItemId()) {
            searchVo.addEqualFilter("itemId", queryReqDto.getItemId().toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getShopIds())) {
            String[] shopIds = (String[])queryReqDto.getShopIds().stream().map(String::valueOf).toArray(String[]::new);
            searchVo.addInFilter("shopId", shopIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemIds())) {
            String[] itemIds = (String[])queryReqDto.getItemIds().stream().map(String::valueOf).toArray(String[]::new);
            searchVo.addInFilter("itemId", itemIds);
        }
        ArrayList list = Lists.newArrayList();
        int pageNum = 1;
        do {
            searchVo.setPage(pageNum);
            searchVo.setPageSize(1000);
            searchResultVo = this.openSearchService.search(searchVo);
            if (null != searchResultVo) {
                List priceDtos = searchResultVo.getDocValues(docValue -> (ItemActivityPriceDto)JacksonUtil.readValue((String)JacksonUtil.toJson((Object)docValue), ItemActivityPriceDto.class));
                list.addAll(priceDtos);
            }
            ++pageNum;
        } while (null != searchResultVo && CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()));
        return list;
    }

    private String getIndexName() {
        return ITEM_ACTIVITY_PRICE + this.globalProfile;
    }

    private Long getIndexId() {
        return IdGenrator.getDistributedId();
    }
}

