/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateStockServiceImpl
implements ICouponTemplateStockService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COUPON_TEMPLATE_STOCK_KEY = "COUPON_TEMPLATE_STOCK_:";
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICacheService cacheService;

    @Override
    public void initStock(Long couponTemplateId) {
        CouponTemplateEo couponTemplateEo = this.couponTemplateExtQueryService.queryEoById(couponTemplateId);
        this.logger.info("\u521d\u59cb\u5316\u4f18\u60e0\u5238\u6a21\u677f\u7684\u53ef\u7528\u5e93\u5b58, couponTemplateId={}, quantity={}", (Object)couponTemplateId, (Object)couponTemplateEo.getRemainingQuantity());
        String cacheKey = this.getCacheKey(couponTemplateId);
        this.cacheService.setPersistCache(cacheKey, (Object)couponTemplateEo.getRemainingQuantity());
    }

    @Override
    public void modifyStock(Long couponTemplateId) {
        CouponTemplateEo couponTemplateEo = this.couponTemplateExtQueryService.queryEoById(couponTemplateId);
        this.logger.info("\u521d\u59cb\u5316\u4f18\u60e0\u5238\u6a21\u677f\u7684\u53ef\u7528\u5e93\u5b58, couponTemplateId={}, quantity={}", (Object)couponTemplateId, (Object)couponTemplateEo.getRemainingQuantity());
        String cacheKey = this.getCacheKey(couponTemplateId);
        this.cacheService.delCache(cacheKey);
        this.cacheService.setPersistCache(cacheKey, (Object)couponTemplateEo.getRemainingQuantity());
    }

    @Override
    public boolean deductionAvailableStock(Long couponTemplateId, Integer quantity) {
        this.logger.info("\u6263\u51cf\u4f18\u60e0\u5238\u6a21\u677f\u7684\u53ef\u7528\u5e93\u5b58, couponTemplateId={}, quantity={}", (Object)couponTemplateId, (Object)quantity);
        String cacheKey = this.getCacheKey(couponTemplateId);
        Long cacheStock = (Long)this.cacheService.getCache(cacheKey, Long.class);
        this.logger.info("\u5f53\u524d\u4f18\u60e0\u5238\u7684redis\u5e93\u5b58, couponTemplateId={}, cacheStock={}", (Object)couponTemplateId, (Object)cacheStock);
        if (cacheStock == null) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STOCK_EXIST.getMsg());
        }
        if (this.cacheService.incrBy(cacheKey, (long)(-quantity.intValue())) < 0L) {
            this.cacheService.incrBy(cacheKey, (long)quantity.intValue());
            return false;
        }
        return true;
    }

    @Override
    public boolean addAvailableStock(Long couponTemplateId, Integer quantity) {
        this.logger.info("\u52a0\u56de\u5e93\u5b58\u91cf==={} , \u5f53\u524d\u6a21\u677fid=={}", (Object)quantity, (Object)couponTemplateId);
        String cacheKey = this.getCacheKey(couponTemplateId);
        Long cacheStock = (Long)this.cacheService.getCache(cacheKey, Long.class);
        if (null == cacheStock) {
            this.logger.info("redis\u7f13\u5b58\u4e0d\u5b58\u5728\u6b64key=={}", (Object)cacheKey);
            this.initStock(couponTemplateId);
            cacheStock = (Long)this.cacheService.getCache(cacheKey, Long.class);
            this.cacheService.setPersistCache(cacheKey, (Object)(cacheStock + (long)quantity.intValue()));
        } else {
            this.logger.info("\u52a0\u56de\u5e93\u5b58----------------------");
            this.cacheService.setPersistCache(cacheKey, (Object)(cacheStock + (long)quantity.intValue()));
        }
        return true;
    }

    @Override
    public Long getAvailableStock(Long couponTemplateId) {
        this.logger.debug("\u4f18\u60e0\u5238\u6a21\u677fid\u83b7\u53d6\u53ef\u7528\u5e93\u5b58, couponTemplateId={}", (Object)couponTemplateId);
        String cacheKey = this.getCacheKey(couponTemplateId);
        Long cacheStock = (Long)this.cacheService.getCache(cacheKey, Long.class);
        this.logger.debug("\u5f53\u524d\u4f18\u60e0\u5238\u7684redis\u5e93\u5b58, couponTemplateId={}, cacheStock={}", (Object)couponTemplateId, (Object)cacheStock);
        if (cacheStock == null) {
            this.initStock(couponTemplateId);
        }
        return cacheStock;
    }

    private String getCacheKey(Long id) {
        return COUPON_TEMPLATE_STOCK_KEY + id;
    }
}

