/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.PersonalizedTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.PersonalizedCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonalizedCouponItemCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(PersonalizedCouponItemCondition.class);
    public static final String CONDNTION = "PersonalizedCouponItemCondition.condition";
    @Resource
    private ICouponExtService couponExtService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        logger.info("\u5f00\u59cb\u6821\u9a8c\u4e2a\u6027\u5316\u5546\u54c1\u6761\u4ef6,templateDefine=={} , conditionRespDto=={} , configParams={}", new Object[]{JSONObject.toJSONString((Object)templateDefine), JSONObject.toJSONString((Object)conditionRespDto), JSONObject.toJSONString(configParams)});
        Param param = templateDefine.getParam(CONDNTION);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6027\u5316\u4f18\u60e0\u5238\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        PersonalizedCouponRespDto dto = (PersonalizedCouponRespDto)ConditionTemplate.converter(configParams.get(CONDNTION), param, templateDefine.getLoadClass());
        if (null != dto && null != dto.getType()) {
            PersonalizedTypeEnum anEnum = PersonalizedTypeEnum.findEnum((Integer)dto.getType());
            List couponIds = context.getCouponIds();
            switch (anEnum) {
                case PERSON_ITEM: {
                    this.validItemRange(context, couponIds);
                    return true;
                }
                case PERSON_DISCOUNT: {
                    BigDecimal bigDecimal = this.couponExtService.queryCouponDiscount((Long)couponIds.get(0));
                    context.setDiscountValue(bigDecimal);
                    return true;
                }
                case PERSON_DATE: {
                    return true;
                }
                case PERSON_ITEM_DISCOUNT: {
                    this.validItemRange(context, couponIds);
                    BigDecimal bigDecima = this.couponExtService.queryCouponDiscount((Long)couponIds.get(0));
                    context.setDiscountValue(bigDecima);
                    return true;
                }
                case PERSON_ITEM_DATE: {
                    this.validItemRange(context, couponIds);
                    return true;
                }
                case PERSON_DISCOUNT_DATE: {
                    return true;
                }
                case PERSON_ITEM_DISCOUNT_DATE: {
                    return true;
                }
                case PERSON_LEAS_PAY: {
                    BigDecimal orderAmount = context.getOrderAmount();
                    BigDecimal leastPayAmt = this.couponExtService.queryCouponLeasPayAmt((Long)couponIds.get(0));
                    if (orderAmount.compareTo(leastPayAmt) == -1) {
                        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u53ef\u7528,\u4e0d\u6ee1\u8db3\u6700\u4f4e\u6d88\u8d39"}));
                    }
                    return true;
                }
                case PERSON_COUPON_COUNT: {
                    BigDecimal couponAmt = this.couponExtService.queryCouponAmt((Long)couponIds.get(0));
                    context.setCouponAmt(couponAmt);
                    return true;
                }
            }
            return false;
        }
        logger.info("dto\u8f6c\u6362\u4e3anull ");
        return false;
    }

    private <T extends EngineParams> List<Long> validItemRange(T context, List<Long> couponIds) {
        List<Long> items = this.couponExtService.queryCouponItemsById(couponIds.get(0));
        if (CollectionUtils.isNotEmpty(items)) {
            context.getItems().removeIf(itemVo -> items.stream().noneMatch(item -> item.equals(itemVo.getItemId())));
            if (CollectionUtils.isEmpty((Collection)context.getItems())) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u53ef\u7528"}));
            }
        }
        return couponIds;
    }

    public static PersonalizedCouponRespDto parseParams(String conditionParams) {
        JSONObject jsonObject;
        if (StringUtils.isNotEmpty((CharSequence)conditionParams) && (jsonObject = JSON.parseObject((String)conditionParams)).containsKey((Object)CONDNTION)) {
            PersonalizedCouponRespDto result = (PersonalizedCouponRespDto)jsonObject.getObject(CONDNTION, PersonalizedCouponRespDto.class);
            return result;
        }
        return null;
    }
}

