/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.apiimpl;

import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.IGroupActivityAggApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.ActivityGroupDetailQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ActivityGroupListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ActivityTermDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.GroupActivityQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IActivityAggService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IGroupActivity;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.IActivityGroupService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="groupActivityAggApiImpl")
public class GroupActivityAggApiImpl
implements IGroupActivityAggApi {
    private static Logger logger = LoggerFactory.getLogger(GroupActivityAggApiImpl.class);
    @Resource
    private IGroupActivity groupActivity;
    @Resource
    private IActivityAggService activityService;
    @Resource
    private IContext context;
    @Resource
    private IActivityGroupService activityGroupService;

    public RestResponse<Long> add(GroupActivityDto groupActivityDto) {
        return new RestResponse((Object)this.groupActivity.add(groupActivityDto));
    }

    public RestResponse<GroupActivityDto> getDetail(Long id) {
        return new RestResponse((Object)this.groupActivity.getDetail(id));
    }

    public RestResponse<PageInfo<GroupActivityQueryRespDto>> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.groupActivity.queryByPage(activityQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<Void> closure(Long id) {
        this.activityService.finish(id);
        return new RestResponse();
    }

    public RestResponse<PageInfo<ActivityGroupListRespDto>> queryActivityGroupByPage(ActivityGroupReqDto activityGroupReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.groupActivity.queryActivityGroupByPage(activityGroupReqDto, pageNum, pageSize));
    }

    public RestResponse<ActivityTermDetailRespDto> queryGroupDetailByPage(String accessToken, Long groupId, Integer pageNum, Integer pageSize) {
        Long userId = null;
        try {
            Map map = TokenUtil.parse((String)accessToken);
            logger.info("Access-Token\u89e3\u6790\u51fa\u7684userId={}", map.get("id"));
        }
        catch (Exception e) {
            logger.info("token\u89e3\u6790\u9519\u8bef:{},", (Object)accessToken);
        }
        ActivityGroupDetailQueryReqDto activityGroupDetailReqDto = new ActivityGroupDetailQueryReqDto();
        activityGroupDetailReqDto.setGroupId(groupId.toString());
        activityGroupDetailReqDto.setUserId(userId);
        return new RestResponse((Object)this.groupActivity.queryGroupDetailByPage(activityGroupDetailReqDto, pageNum, pageSize));
    }

    public RestResponse<Void> delete(Long id) {
        this.activityService.delete(id);
        return new RestResponse();
    }

    public RestResponse<Integer> queryGroupSuccess(String orderNo) {
        ActivityGroupRespDto activityGroupRespDto = this.activityGroupService.getByOrderNo(orderNo);
        if (Objects.isNull(activityGroupRespDto)) {
            return new RestResponse((Object)0);
        }
        Integer result = 0;
        if (Objects.equals(activityGroupRespDto.getGroupStatus(), 1)) {
            result = 1;
        }
        return new RestResponse((Object)result);
    }
}

