/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.IScheduleService;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements IScheduleService {
    @Resource
    private ITaskApi iTaskApi;
    String SCHEDULER_SHARD_TYPE = "SINGLE";
    public static String DATEFORMAT = "ss mm HH dd MM ? yyyy";
    String DO_PAY_PREFIX = "\u5f71\u54cd\u4e2d\u5fc3_\u62fc\u56e2\u8d85\u65f6_";
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    private Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);

    @Override
    public void addGroupActivityOverTime(Long groupId, Date endTime, Long tenantId, Long instanceId) {
        this.logger.info("\u6d3b\u52a8={}\u65b0\u5efa\u5173\u95ed\u6d3b\u52a8\u8c03\u5ea6\u4efb\u52a1\u65f6\u95f4{}", (Object)groupId, (Object)DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setInstanceId(instanceId);
        taskAndBizCreateReqDto.setTenantId(tenantId);
        taskAndBizCreateReqDto.setTaskName(this.DO_PAY_PREFIX + groupId);
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode("groupActivityOverTimeScheduler");
        taskAndBizCreateReqDto.setBizName("\u62fc\u56e2\u8d85\u65f6");
        taskAndBizCreateReqDto.setShardType(this.SCHEDULER_SHARD_TYPE);
        taskAndBizCreateReqDto.setTaskBatchId(null);
        HashMap<String, Long> param = new HashMap<String, Long>(16);
        param.put("groupId", groupId);
        taskAndBizCreateReqDto.setParams(ObjectHelper.bean2Json(param));
        taskAndBizCreateReqDto.setScheduleExpression(ScheduleServiceImpl.getCron(endTime));
        RestResponse restResponse = this.iTaskApi.addWithBiz(taskAndBizCreateReqDto);
        if ("0".equals(restResponse.getResultCode())) {
            RequestDto requestDto = new RequestDto();
            requestDto.setInstanceId(instanceId);
            requestDto.setTenantId(tenantId);
            this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
        }
    }

    public static String getCron(Date date) {
        if (date == null) {
            throw new BizException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return DateUtil.getDateFormat((Date)date, (String)DATEFORMAT);
    }
}

