/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.condition;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model.ItemPurchaseLimit;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.constants.enums.ItemLimitLevel;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseLimitCondition
extends ConditionTemplate
implements ILoadConditionTemplate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICacheService commonCacheService;
    private static final String CONFIG_PARAM_KEY_ITEMS = "PurchaseLimitCondition.items";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u9002\u7528\u5546\u54c1\u9650\u8d2d\u672a\u914d\u7f6e"}));
        }
        List purchaseLimits = (List)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)purchaseLimits)) {
            return true;
        }
        Integer itemLimitLevel = ((ItemPurchaseLimit)purchaseLimits.get(0)).getLimitLevel();
        List items = params.getItems();
        Map<String, Integer> spuLimitMap = purchaseLimits.stream().collect(Collectors.toMap(limit -> limit.getShopId() + limit.getItemId().toString(), ItemPurchaseLimit::getLimitQuantitySingle, (e1, e2) -> e2));
        Map<String, Integer> skuLimitMap = purchaseLimits.stream().collect(Collectors.toMap(limit -> limit.getShopId() + limit.getSkuId().toString(), ItemPurchaseLimit::getLimitQuantitySingle, (e1, e2) -> e2));
        for (ItemVo itemVo : items) {
            Integer limitNum = ItemLimitLevel.SPU.getLevel().equals(itemLimitLevel) ? spuLimitMap.get(itemVo.getShopId() + itemVo.getItemId()) : skuLimitMap.get(itemVo.getShopId() + itemVo.getSkuId());
            if (null == limitNum) break;
            int purchaseNum = itemVo.getNum();
            if (purchaseNum <= limitNum) continue;
            throw new BizException("\u5df2\u7ecf\u8d85\u51fa\u6d3b\u52a8\u7684\u9650\u8d2d\u6570\u91cf");
        }
        params.getExtendsAttribute().put("exchangeItemLimit", ((ItemPurchaseLimit)purchaseLimits.get(0)).getItemLimit());
        params.getExtendsAttribute().put("limitQuantitySingle", skuLimitMap);
        return true;
    }

    @Override
    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u54c1\u9650\u8d2d\u6570\u91cf\u5f00\u59cb=====", (Object)conditionRespDto.getActivityId());
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        List purchaseLimits = (List)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isNotEmpty((Collection)purchaseLimits)) {
            purchaseLimits.forEach(itemPurchaseLimit -> this.commonCacheService.hset(SeckillKeyUtil.getCacheKey("activity_item_limit", conditionRespDto.getActivityId()), SeckillKeyUtil.getKey("_", itemPurchaseLimit.getShopId(), itemPurchaseLimit.getItemId()), (Object)itemPurchaseLimit.getLimitQuantitySingle(), expire));
        }
        this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u54c1\u9650\u8d2d\u6570\u91cf\u7ed3\u675f=====", (Object)conditionRespDto.getActivityId());
    }
}

