/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.agg.apiimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.IMerchantAggApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.IShopAggApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.Merchant;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.MerchantInfo;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.User;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request.MerchantQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response.MerchantInfoRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.enums.ShopModuleExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerBusinessScopeRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.exception.SellerExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.ShopModuleHelper;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.VirtualRelateBusinessReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgGroupRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgGroupQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class MerchantAggApiImpl
implements IMerchantAggApi {
    private static final Logger logger = LoggerFactory.getLogger(MerchantAggApiImpl.class);
    @Resource
    private ISellerApi sellerApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IContext context;
    @Autowired
    private ShopModuleHelper shopModuleHelper;
    @Autowired
    private IShopAggApi shopAggApiImpl;
    @Resource
    private IOrganizationApi organizationApi;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IEmployeeApi employeeApi;
    @Value(value="${dtyunxi.boc.shop.instanceId:1240276043307355174}")
    private Long bocInstanceId;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IOrgGroupQueryApi orgGroupQueryApi;

    public Long add(Merchant merchant, Boolean needAudit) {
        logger.info("\u65b0\u589e\u5546\u5bb6\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)merchant));
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        if (merchant.getInstanceId() != null) {
            instanceId = merchant.getInstanceId();
        }
        if (merchant.getTenantId() != null) {
            tenantId = merchant.getTenantId();
        }
        SellerReqDto sellerReqDto = new SellerReqDto();
        CubeBeanUtils.copyProperties((Object)sellerReqDto, (Object)merchant, (String[])new String[0]);
        this.shopModuleHelper.transMerchantParam(merchant, tenantId, instanceId, sellerReqDto);
        sellerReqDto.setOwnerId(merchant.getOwnerId());
        sellerReqDto.setStatus("NORMAL");
        RestResponse ret = this.sellerApi.addSeller(sellerReqDto, false);
        RestResponseHelper.checkOrThrow((RestResponse)ret);
        for (SellerBusinessScopeReqDto sellerBusScopeReqDto : sellerReqDto.getSellerBusinessScopeReqDtoList()) {
            sellerBusScopeReqDto.setSellerId((Long)ret.getData());
            this.sellerApi.addSellerBusinessScope(sellerBusScopeReqDto);
        }
        if (merchant.getDistributorType() == null || merchant.getDistributorType() == 2) {
            this.giveRoleToAccount(instanceId, merchant.getOwnerId(), merchant.getRoleCode());
        }
        return (Long)ret.getData();
    }

    private void giveRoleToAccount(Long instanceId, Long userId, String roleCode) {
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            roleCode = "merchant";
        }
        if (StringUtils.equals((CharSequence)"distributor", (CharSequence)roleCode)) {
            instanceId = this.bocInstanceId;
        }
        logger.info("\u521d\u59cb\u5316\u8d26\u53f7\u89d2\u8272,\u5b9e\u4f8bid\u4e3a:{},\u7528\u6237id\u4e3a:{}\uff0c\u89d2\u8272\u7f16\u7801\u4e3a:{}", new Object[]{instanceId, userId, roleCode});
        RoleDto roleDto = (RoleDto)this.accessQueryApi.queryRoleByCodeOrName(instanceId, roleCode, null).getData();
        if (roleDto != null) {
            UserDto userDto;
            ArrayList<Long> roleList = new ArrayList<Long>();
            roleList.add(roleDto.getId());
            RestResponse voidRestResponse = this.accessApi.giveUserRoles(instanceId, userId, roleList);
            if ("0".equals(voidRestResponse.getResultCode()) && "distributor".equals(roleCode) && (userDto = (UserDto)this.userQueryApi.queryById(userId, "{}").getData()) != null) {
                UserDto dto = new UserDto();
                dto.setInstanceId(userDto.getInstanceId());
                dto.setTenantId(userDto.getTenantId());
                dto.setUserName(userDto.getPhone());
                byte[] encode = Base64Utils.encode((byte[])userDto.getPhone().getBytes(StandardCharsets.UTF_8));
                String pwd = new String(encode);
                dto.setPassword(pwd.replaceAll("=", ""));
                logger.info("\u4fee\u6539\u5bc6\u7801\u7684\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)dto));
                RestResponse response = this.userApi.updatePasswordPermitted(userId, dto);
                logger.info("\u7528\u7684\u662f\u65b0\u65b9\u6cd5\u4fee\u6539\u5bc6\u7801\u8fd4\u56de\u7684\u7ed3\u679c:{}", (Object)JacksonUtil.toJson((Object)response));
            }
        }
    }

    public RestResponse<Void> enable(Long merchantId) {
        SellerReqDto sellerReqDto = new SellerReqDto();
        sellerReqDto.setId(merchantId);
        sellerReqDto.setStatus("NORMAL");
        RestResponse restResponse = this.sellerApi.modifySeller(sellerReqDto, false);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        this.disableSellerAccount(merchantId, "NORMAL");
        return new RestResponse();
    }

    public RestResponse<Void> disable(Long merchantId) {
        SellerReqDto sellerReqDto = new SellerReqDto();
        sellerReqDto.setId(merchantId);
        sellerReqDto.setStatus("BANNED");
        RestResponse restResponse = this.sellerApi.modifySeller(sellerReqDto, false);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        this.disableSellerAccount(merchantId, "BANNED");
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setSellerId(merchantId);
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseShopList(shopQueryDto));
        if (CollectionUtils.isNotEmpty((Collection)shopList)) {
            for (ShopBaseDto shopDto : shopList) {
                this.shopAggApiImpl.disableShop(shopDto.getId());
            }
        }
        return new RestResponse();
    }

    private void disableSellerAccount(Long merchantId, String status) {
        UserDto exam = new UserDto();
        if ("NORMAL".equals(status)) {
            exam.setStatus(Integer.valueOf(1));
        } else {
            exam.setStatus(Integer.valueOf(2));
        }
        ArrayList filter = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("property", "extension");
        map.put("operator", "eq");
        map.put("value", merchantId.toString());
        filter.add(map);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantId", (Object)this.context.tenantId());
        jsonObject.put("instanceId", (Object)this.context.instanceId());
        jsonObject.put("filters", filter);
        logger.debug("\u67e5\u8be2\u7528\u6237\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)jsonObject.toJSONString());
        List userDtoList = ((PageInfo)this.userQueryApi.queryByPage(jsonObject.toJSONString(), Integer.valueOf(1), Integer.valueOf(100)).getData()).getList();
        if (CollectionUtils.isNotEmpty((Collection)userDtoList)) {
            for (UserDto userDto : userDtoList) {
                this.userApi.update(userDto.getId(), exam);
            }
        }
    }

    public RestResponse<Long> createMerchant(MerchantInfo merchantInfo) {
        return new RestResponse((Object)this.createMerchantData(merchantInfo).getId());
    }

    private Merchant createMerchantData(MerchantInfo merchantInfo) {
        logger.info("\u521d\u59cb\u5316\u5546\u5bb6\u6570\u636e:{}", (Object)JacksonUtil.toJson((Object)merchantInfo));
        Merchant merchant = merchantInfo.getMerchant();
        User user = merchantInfo.getUser();
        if (StringUtils.isBlank((CharSequence)user.getUserName()) && user.getId() == null) {
            throw new BizException("\u6ce8\u518c\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean exits = (Boolean)RestResponseHelper.extractData((RestResponse)this.sellerApi.checkSellerName(merchant.getName()));
        logger.info("\u521d\u59cb\u5316\u5546\u5bb6\u6570\u636eexits:{}", (Object)exits);
        if (exits.booleanValue()) {
            throw new BizException(SellerExceptionCode.SELLER_NAME_ISEXIST.getCode(), SellerExceptionCode.SELLER_NAME_ISEXIST.getMsg());
        }
        Long userId = user.getId();
        logger.info("\u7528\u6237id\u4e3a:{}", (Object)userId);
        UserDto userRespDto = null;
        if (userId == null) {
            userRespDto = this.shopModuleHelper.relateAccount(user.getUserName(), 2);
            userId = userRespDto.getId();
        } else {
            userRespDto = new UserDto();
            userRespDto.setId(userId);
        }
        SellerQueryReqDto reqExam = new SellerQueryReqDto();
        reqExam.setOwnerId(userId);
        if (merchant.getInstanceId() == null) {
            reqExam.setInstanceId(this.context.instanceId());
        } else {
            reqExam.setInstanceId(merchant.getInstanceId());
        }
        List sellerRespDtoList = (List)this.sellerQueryApi.queryList(reqExam).getData();
        if (CollectionUtils.isNotEmpty((Collection)sellerRespDtoList) && sellerRespDtoList.get(0) != null && ((SellerRespDto)sellerRespDtoList.get(0)).getId() != 0L) {
            throw new BizException(ShopModuleExceptionCode.BIND_MERCHANT_EXIST.getCode(), ShopModuleExceptionCode.BIND_MERCHANT_EXIST.getMsg());
        }
        Long orgId = this.autoOrganization(merchant);
        merchant.setOrganizationId(orgId);
        merchant.setOrganizationName(merchant.getName());
        merchant.setOwnerId(userId);
        merchant.setCode("M" + System.currentTimeMillis());
        merchant.setAccount(user.getUserName());
        Long sellerId = this.add(merchant, false);
        UserDto exam = new UserDto();
        exam.setExtension(sellerId.toString());
        this.userApi.update(userId, exam);
        this.autoEmployee(merchant, userRespDto, orgId);
        if (StringUtils.isNotBlank((CharSequence)userRespDto.getUserName())) {
            if (StringUtils.isNotBlank((CharSequence)userRespDto.getPassword())) {
                this.shopModuleHelper.sendSms(userRespDto.getUserName(), "ApplyMerchant_001", "password", userRespDto.getPassword());
            } else {
                this.shopModuleHelper.sendSms(userRespDto.getUserName(), "ApplyMerchant_002", null, null);
            }
        }
        merchant.setOrganizationId(orgId);
        merchant.setId(sellerId);
        return merchant;
    }

    public Long autoOrganization(Merchant merchant) {
        OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
        orgAdvAddReqDto.setType("2");
        orgAdvAddReqDto.setParentId(merchant.getOrganizationId());
        orgAdvAddReqDto.setName(merchant.getName());
        orgAdvAddReqDto.setCode("merchant_" + System.currentTimeMillis());
        orgAdvAddReqDto.setEntityPropCode("merchant");
        ArrayList typeCodes = Lists.newArrayList();
        typeCodes.add("human_resource");
        orgAdvAddReqDto.setFuncTypeCodes((List)typeCodes);
        logger.info("\u65b0\u589e\u7ec4\u7ec7\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)orgAdvAddReqDto));
        OrgAdvOpRespDto orgAdvOpRespDto = (OrgAdvOpRespDto)RestResponseHelper.extractData((RestResponse)this.organizationExtApi.add(orgAdvAddReqDto));
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryById(merchant.getOrganizationId()));
        if ("3".equals(orgAdvDetailRespDto.getType())) {
            logger.info("\u6ee1\u8db3\u6761\u4ef6");
            VirtualRelateBusinessReqDto virtualRelateBusinessReqDto = new VirtualRelateBusinessReqDto();
            OrgGroupQueryReqDto orgGroupQueryReqDto = new OrgGroupQueryReqDto();
            orgGroupQueryReqDto.setFuncTypeCode("human_resource");
            PageInfo orgGroupRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orgGroupQueryApi.queryByPage(orgGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(10)));
            List orgGroupRespDtos = orgGroupRespDtoPageInfo.getList();
            virtualRelateBusinessReqDto.setOrgGroupId(((OrgGroupRespDto)orgGroupRespDtos.get(0)).getId());
            virtualRelateBusinessReqDto.setId(orgAdvOpRespDto.getOrgId());
            virtualRelateBusinessReqDto.setParentId(orgAdvDetailRespDto.getId());
            logger.info("\u6dfb\u52a0\u4e1a\u52a1\u5355\u5143\u4e0e\u865a\u62df\u5355\u5143\u7684\u5173\u8054\u5173\u7cfbvirtualRelateBusinessReqDto:{}", (Object)JSON.toJSONString((Object)virtualRelateBusinessReqDto));
            RestResponseHelper.extractData((RestResponse)this.organizationExtApi.virtualRelateBusiness(virtualRelateBusinessReqDto));
        }
        Long orgId = orgAdvOpRespDto.getOrgId();
        if (orgAdvOpRespDto.getResultCode() == 0) {
            throw new BizException(String.valueOf(orgAdvOpRespDto.getResultCode()), orgAdvOpRespDto.getResultMsg());
        }
        return orgId;
    }

    public void autoEmployee(Merchant merchant, UserDto userRespDto, Long orgId) {
        EmployeeAddReqDto employeeAddReqDto = new EmployeeAddReqDto();
        employeeAddReqDto.setName(merchant.getContactPerson());
        employeeAddReqDto.setPhoneNum(merchant.getContactMobile());
        employeeAddReqDto.setEmployeeNo("emp_" + System.currentTimeMillis());
        ArrayList<OrgOrgDto> orgDtoList = new ArrayList<OrgOrgDto>();
        OrgOrgDto orgOrgDto = new OrgOrgDto();
        orgOrgDto.setOrgId(orgId);
        orgOrgDto.setOrgGroupId(orgId);
        orgDtoList.add(orgOrgDto);
        employeeAddReqDto.setOrgDtoList(orgDtoList);
        employeeAddReqDto.setUserId(userRespDto.getId());
        employeeAddReqDto.setTenantId(Long.valueOf(1L));
        logger.info("\u5458\u5de5\u4fe1\u606f" + JSONObject.toJSONString((Object)employeeAddReqDto));
        Long employeeId = (Long)RestResponseHelper.extractData((RestResponse)this.employeeApi.addEmployee(employeeAddReqDto));
        if (employeeId == null) {
            throw new BizException("\u65b0\u589e\u5458\u5de5\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        merchant.setEmployeeId(employeeId);
        logger.info("\u5546\u5bb6\u8d26\u53f7\u5173\u8054\u5458\u5de5\uff1a{},\u7528\u6237id\uff1a{}", (Object)employeeId, (Object)userRespDto.getId());
        this.organizationApi.relateEmployeeUser(employeeId, userRespDto.getId());
    }

    public RestResponse<Void> modify(Long merchantId, MerchantInfo merchantInfo) {
        Merchant merchant = merchantInfo.getMerchant();
        this.checkMerchantParam(merchant);
        SellerReqDto sellerReqDto = new SellerReqDto();
        CubeBeanUtils.copyProperties((Object)sellerReqDto, (Object)merchant, (String[])new String[0]);
        sellerReqDto.setId(merchantId);
        this.shopModuleHelper.transMerchantParam(merchant, this.context.tenantId(), this.context.instanceId(), sellerReqDto);
        List businessScopeList = sellerReqDto.getSellerBusinessScopeReqDtoList();
        sellerReqDto.setSellerBusinessScopeReqDtoList(null);
        if (sellerReqDto.getId() != null) {
            RestResponse restResponse = this.sellerApi.modifySeller(sellerReqDto, false);
            if (!"0".equals(restResponse.getResultCode())) {
                throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
            }
            List bizScopeList = (List)this.sellerQueryApi.queryBySellerId(merchantId).getData();
            if (CollectionUtils.isNotEmpty((Collection)bizScopeList)) {
                for (SellerBusinessScopeRespDto bizScopeDto : bizScopeList) {
                    this.sellerApi.removeBusinessById(bizScopeDto.getId());
                }
            }
            for (SellerBusinessScopeReqDto sellerBusScopeReqDto : businessScopeList) {
                sellerBusScopeReqDto.setSellerId(merchantId);
                this.sellerApi.addSellerBusinessScope(sellerBusScopeReqDto);
            }
        }
        return new RestResponse();
    }

    private void checkMerchantParam(Merchant merchant) {
        if (merchant == null) {
            throw new BizException("\u5546\u6237\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getStatus())) {
            throw new BizException("\u5546\u5bb6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getContactPerson())) {
            throw new BizException("\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getContactMobile())) {
            throw new BizException("\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getEmail())) {
            throw new BizException("\u5e38\u7528\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getCompanyName())) {
            throw new BizException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getAddress())) {
            throw new BizException("\u516c\u53f8\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)merchant.getContactPhone())) {
            throw new BizException("\u516c\u53f8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public RestResponse<List<MerchantInfoRespDto>> querySellers(MerchantQueryDto merchantQueryDto) {
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        CubeBeanUtils.copyProperties((Object)sellerQueryReqDto, (Object)merchantQueryDto, (String[])new String[0]);
        List sellerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        ArrayList merchantInfoRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(merchantInfoRespDtos, (Collection)sellerDtoList, MerchantInfoRespDto.class);
        return new RestResponse(merchantInfoRespDtos);
    }
}

