/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.export;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.export.IStorageShopService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StrorageShopServiceImpl
implements IStorageShopService {
    private static Logger logger = LoggerFactory.getLogger(StrorageShopServiceImpl.class);
    @Autowired
    private IObjectStorageService objectStorageService;
    @Value(value="${huieryun.ossregistryvo.bucketName}")
    private String bucketName;
    @Value(value="${huieryun.ossregistryvo.endpoint}")
    private String endpoint;
    @Value(value="${huieryun.ossregistryvo.dir}")
    private String dir;
    private String EXPORT_DIR = "export";

    @Override
    public String getFileUrl(String fileName) {
        return this.endpoint + "/" + this.dir + this.EXPORT_DIR + "/" + fileName;
    }

    @Override
    public void uploadFile(File file, String fileName) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error("\u65b0\u5efa\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            throw new BizException("\u65b0\u5efa\u6587\u4ef6\u6d41\u5931\u8d25");
        }
        String filePath = this.EXPORT_DIR + "/" + fileName;
        this.objectStorageService.put(this.bucketName, filePath, (InputStream)input);
        logger.info("\u6587\u4ef6\u540d\u5b57{}", (Object)filePath);
    }

    @Override
    public Boolean checkExportFinish(String downloadFileName) {
        String filePath = this.EXPORT_DIR + "/" + downloadFileName;
        return this.objectStorageService.exists(this.bucketName, filePath);
    }
}

