/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerBusinessScopeRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;

@Service(value="sellerQueryApi")
public class SellerQueryApiImpl
implements ISellerQueryApi {
    @Autowired
    ISellerService iSellerService;
    @Autowired
    ISellerBusinessScopeService iSellerBusinessScopeService;
    @Autowired
    private IOrganizationQueryApi organizationQueryApi;

    public RestResponse<List<SellerRespDto>> queryByInstanceId(@PathVariable(value="instanceId") Long instanceId) {
        List<SellerEo> sellerEos = this.iSellerService.queryByInstanceId(instanceId);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }

    public RestResponse<List<SellerRespDto>> queryByTenantId(@PathVariable(value="tenantId") Long tenantId) {
        List<SellerEo> sellerEos = this.iSellerService.queryByTenantId(tenantId);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }

    public RestResponse<List<SellerBusinessScopeRespDto>> queryBySellerId(@PathVariable(value="sellerId") Long sellerId) {
        List<SellerBusinessScopeEo> sellerBusinessScopeEos = this.iSellerBusinessScopeService.queryBusinessScopeBySellerId(sellerId);
        ArrayList sellerBusinessScopeRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerBusinessScopeEos)) {
            DtoHelper.eoList2DtoList(sellerBusinessScopeEos, (Collection)sellerBusinessScopeRespDtos, SellerBusinessScopeRespDto.class);
            return new RestResponse((Object)sellerBusinessScopeRespDtos);
        }
        return new RestResponse((Object)sellerBusinessScopeRespDtos);
    }

    public RestResponse<PageInfo<SellerRespDto>> queryPageSeller(SellerQueryReqDto sellerQueryReqDto) {
        PageInfo<SellerEo> pageInfo = this.iSellerService.queryPageSeller(sellerQueryReqDto);
        ArrayList list = Lists.newArrayList();
        PageInfo dtoPageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)list, SellerRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        for (SellerRespDto sellerRespDto : list) {
            List sellerAreaDtoList = (List)this.queryAreaBySellerId(sellerRespDto.getId()).getData();
            sellerRespDto.setSellerAreaDtoList(sellerAreaDtoList);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    public RestResponse<PageInfo<SellerRespDto>> queryPageSellerByBusinessScope(SellerQueryReqDto sellerQueryReqDto) {
        PageInfo<SellerEo> pageInfo = this.iSellerService.queryPageSellerByBusinessScope(sellerQueryReqDto);
        ArrayList list = Lists.newArrayList();
        PageInfo dtoPageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)list, SellerRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return new RestResponse((Object)dtoPageInfo);
    }

    public RestResponse<List<SellerRespDto>> queryList(SellerQueryReqDto sellerQueryReqDto) {
        List<SellerEo> sellerEos = this.iSellerService.queryList(sellerQueryReqDto);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }

    public RestResponse<List<SellerRespDto>> queryByCode(String code) {
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setCode(code);
        List<SellerEo> sellerEos = this.iSellerService.queryList(sellerQueryReqDto);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }

    public RestResponse<List<SellerRespDto>> queryListByFeign(SellerQueryReqDto sellerQueryReqDto) {
        List<SellerEo> sellerEos = this.iSellerService.queryList(sellerQueryReqDto);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }

    public RestResponse<SellerBusinessScopeRespDto> queryBusinessScopeBySellerIdAndBusinessId(@PathVariable(value="sellerId") Long sellerId, @PathVariable(value="businessId") Long businessId) {
        SellerBusinessScopeRespDto sellerBusinessScopeRespDto = new SellerBusinessScopeRespDto();
        SellerBusinessScopeEo sellerBusinessScopeEo = this.iSellerBusinessScopeService.queryBusinessScopeBySellerIdAndBusinessId(sellerId, businessId);
        DtoHelper.eo2Dto((BaseEo)sellerBusinessScopeEo, (BaseVo)sellerBusinessScopeRespDto);
        return new RestResponse((Object)sellerBusinessScopeRespDto);
    }

    public RestResponse<SellerRespDto> queryById(@PathVariable(value="id") Long id) {
        if (id == null || id == 0L) {
            return new RestResponse(null);
        }
        SellerEo sellerEo = this.iSellerService.querySellerById(id);
        SellerRespDto sellerRespDto = new SellerRespDto();
        DtoHelper.eo2Dto((BaseEo)sellerEo, (BaseVo)sellerRespDto);
        return new RestResponse((Object)sellerRespDto);
    }

    public RestResponse<List<SellerAreaDto>> queryAreaBySellerId(Long sellerId) {
        List<SellerAreaEo> sellerAreaEoList = this.iSellerService.querySellerAreaList(sellerId);
        ArrayList sellerAreaDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(sellerAreaEoList, (Collection)sellerAreaDtoList, SellerAreaDto.class);
        return new RestResponse((Object)sellerAreaDtoList);
    }

    public RestResponse<List<SellerAreaDto>> queryAreaList(SellerAreaDto sellerAreaDto) {
        List<SellerAreaEo> sellerAreaEoList = this.iSellerService.querySellerAreaList(sellerAreaDto);
        ArrayList sellerAreaDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(sellerAreaEoList, (Collection)sellerAreaDtoList, SellerAreaDto.class);
        return new RestResponse((Object)sellerAreaDtoList);
    }

    public RestResponse<List<SellerRespDto>> queryListOnPost(SellerQueryReqDto sellerQueryReqDto) {
        List<SellerEo> sellerEos = this.iSellerService.queryList(sellerQueryReqDto);
        ArrayList sellerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sellerEos)) {
            DtoHelper.eoList2DtoList(sellerEos, (Collection)sellerRespDtos, SellerRespDto.class);
            return new RestResponse((Object)sellerRespDtos);
        }
        return new RestResponse((Object)sellerRespDtos);
    }
}

