/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.constant.RuleAreaType;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightRuleReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.RuleAreaBase;
import com.dtyunxi.yundt.cube.center.shop.biz.bo.cache.AreaCache;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightRuleAreaService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightRuleService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.FreightRuleDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreightRuleAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreightRuleEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdFreightRuleAreaEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freightRuleService")
public class FreightRuleServiceImpl
implements IFreightRuleService {
    @Autowired
    private FreightRuleDas freightRuleDas;
    @Autowired
    private IFreightRuleAreaService freightRuleAreaService;
    @Autowired
    private IAreaQueryApi areaQueryApi;

    @Override
    public List<FreightRuleRespDto> add(Long templateId, List<FreightRuleReqDto> ruleReqDtos) {
        FreightRuleEo deleteEo = FreightRuleEo.newInstance();
        deleteEo.setFreightTemplateId(templateId);
        List deleteList = this.freightRuleDas.selectList((BaseEo)deleteEo);
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.eq((String)"freightTemplateId", (Object)templateId));
        deleteEo.setSqlFilters((List)filters);
        deleteEo.setFreightTemplateId(null);
        this.freightRuleDas.logicDelete((BaseEo)deleteEo);
        if (deleteList != null && !deleteList.isEmpty()) {
            List<Long> ruleIds = deleteList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.freightRuleAreaService.delete(ruleIds, RuleAreaType.COST);
        }
        if (CollectionUtils.isEmpty(ruleReqDtos)) {
            return null;
        }
        List<FreightRuleEo> eoList = this.getEoList(templateId, ruleReqDtos);
        if (CollectionUtils.isEmpty(eoList)) {
            return null;
        }
        this.freightRuleDas.insertBatch(eoList);
        eoList.forEach(eo -> this.freightRuleAreaService.add(eo.getId(), eo.getAreaCode(), RuleAreaType.COST));
        return null;
    }

    @Override
    public List<FreightRuleRespDto> getRules(Long templateId) {
        return this.getRules(templateId, false, false);
    }

    @Override
    public List<FreightRuleRespDto> getRules(List<Long> templateIds, boolean getName, boolean getTree) {
        FreightRuleEo eo = FreightRuleEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"freightTemplateId", templateIds));
        eo.setSqlFilters((List)sqlFilters);
        List result = this.freightRuleDas.select((BaseEo)eo);
        if (result == null || result.isEmpty()) {
            return null;
        }
        List<Long> ruleIds = result.stream().map(BaseEo::getId).collect(Collectors.toList());
        List<FreightRuleAreaEo> areaCodes = this.freightRuleAreaService.getAreaList(ruleIds, RuleAreaType.COST);
        List<AreaTreeRespDto> areaTreeRespDtoList = null;
        if (getName || getTree) {
            areaTreeRespDtoList = AreaCache.AREA_TREE_CACHE;
        }
        return this.eo2Resp(result, areaCodes, areaTreeRespDtoList);
    }

    @Override
    public List<FreightRuleRespDto> getRules(Long templateId, boolean getName, boolean getTree) {
        ArrayList<Long> templateIds = new ArrayList<Long>();
        templateIds.add(templateId);
        return this.getRules(templateIds, getName, getTree);
    }

    private FreightRuleRespDto eo2Resp(FreightRuleEo eo, List<String> areaCodeList, List<AreaTreeRespDto> areaTreeRespDtoList) {
        if (eo == null) {
            return null;
        }
        if (areaCodeList == null || areaCodeList.isEmpty()) {
            return null;
        }
        FreightRuleRespDto respDto = new FreightRuleRespDto();
        BeanUtil.copyProperties((Object)eo, (Object)respDto, (String[])new String[0]);
        respDto.setAreaCodes(areaCodeList);
        if (areaTreeRespDtoList != null) {
            this.freightRuleAreaService.setAreaMoreInfo((RuleAreaBase)respDto, areaTreeRespDtoList);
        }
        return respDto;
    }

    private List<FreightRuleRespDto> eo2Resp(List<FreightRuleEo> eoList, List<FreightRuleAreaEo> areaCodeList, List<AreaTreeRespDto> areaTreeRespDtoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return null;
        }
        ArrayList<FreightRuleRespDto> list = new ArrayList<FreightRuleRespDto>();
        eoList.forEach(eo -> {
            List<String> collect = areaCodeList.stream().filter(e -> e.getFreightRuleId().equals(eo.getId())).map(StdFreightRuleAreaEo::getAreaCode).collect(Collectors.toList());
            FreightRuleRespDto respDto = this.eo2Resp((FreightRuleEo)eo, collect, areaTreeRespDtoList);
            if (respDto != null) {
                list.add(respDto);
            }
        });
        return list;
    }

    private List<FreightRuleEo> getEoList(Long templateId, List<FreightRuleReqDto> ruleReqDtos) {
        if (CollectionUtils.isEmpty(ruleReqDtos)) {
            return Collections.emptyList();
        }
        ArrayList<FreightRuleEo> eoList = new ArrayList<FreightRuleEo>();
        ruleReqDtos.forEach(ruleReqDto -> {
            ruleReqDto.setFreightTemplateId(templateId);
            FreightRuleEo eo = this.getEo((FreightRuleReqDto)ruleReqDto);
            eoList.add(eo);
        });
        return eoList;
    }

    private FreightRuleEo getEo(FreightRuleReqDto ruleReqDto) {
        if (CollectionUtils.isEmpty((Collection)ruleReqDto.getDeliveryAreaDtoList())) {
            throw new BizException("\u8fd0\u8d39\u89c4\u5219\u9002\u7528\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ruleReqDto.list2Text();
        FreightRuleEo eo = FreightRuleEo.newInstance();
        BeanUtil.copyProperties((Object)ruleReqDto, (Object)eo, (String[])new String[0]);
        return eo;
    }
}

