/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.constant.DrEnum;
import com.dtyunxi.yundt.cube.center.shop.api.constant.FreightTemplateState;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreeFreightRuleReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightRuleReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightTemplatePageReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightTemplateReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreeFreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateSimpleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.bo.cache.AreaCache;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreeFreightRuleService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightRuleService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightTemplateService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.FreightTemplateDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreightTemplateEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="freightTemplateService")
public class FreightTemplateServiceImpl
implements IFreightTemplateService {
    private Logger logger = LoggerFactory.getLogger(FreightTemplateServiceImpl.class);
    @Autowired
    private IFreeFreightRuleService freeFreightRuleService;
    @Autowired
    private IFreightRuleService freightRuleService;
    @Autowired
    private FreightTemplateDas freightTemplateDas;
    @Autowired
    private IAreaQueryApi iAreaQueryApi;

    @Override
    @Transactional
    public Long add(FreightTemplateReqDto freightTemplateReqDto) {
        this.checkArea(freightTemplateReqDto);
        FreightTemplateEo freightTemplateEo = this.getEo(freightTemplateReqDto);
        try {
            this.freightTemplateDas.insert((BaseEo)freightTemplateEo);
        }
        catch (DuplicateKeyException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException(ShopExceptionCode.SHOP_TEMPLATE_CODE_ISEXIST.getCode(), ShopExceptionCode.SHOP_TEMPLATE_CODE_ISEXIST.getMsg());
        }
        Long templateId = freightTemplateEo.getId();
        if (freightTemplateReqDto.getFreeFreight() != null && freightTemplateReqDto.getFreeFreight() == 1) {
            if (CollectionUtils.isEmpty((Collection)freightTemplateReqDto.getFreeFreightRuleList())) {
                throw new BizException("\u542f\u7528\u514d\u90ae\u89c4\u5219\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e00\u6761\u514d\u90ae\u89c4\u5219");
            }
        } else {
            freightTemplateReqDto.setFreeFreightRuleList(null);
        }
        this.freightRuleService.add(templateId, freightTemplateReqDto.getFreightRuleList());
        this.freeFreightRuleService.add(templateId, freightTemplateReqDto.getFreeFreightRuleList());
        return templateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkArea(FreightTemplateReqDto freightTemplateReqDto) {
        long current = System.currentTimeMillis();
        try {
            List<AreaTreeRespDto> areaTreeRespDtoList = this.getAreaTree(freightTemplateReqDto);
            if (areaTreeRespDtoList == null) {
                return;
            }
            this.checkFreightRule(freightTemplateReqDto.getFreightRuleList(), areaTreeRespDtoList);
            this.checkFreeFreightRule(freightTemplateReqDto.getFreeFreightRuleList(), areaTreeRespDtoList);
        }
        finally {
            this.logger.info("\u6821\u9a8c\u533a\u57df\u7528\u65f6:{}ms", (Object)(System.currentTimeMillis() - current));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFreightRule(List<FreightRuleReqDto> ruleReqDtos, List<AreaTreeRespDto> areaTreeRespDtoList) {
        long current = System.currentTimeMillis();
        try {
            if (ruleReqDtos == null || ruleReqDtos.isEmpty()) {
                return;
            }
            HashMap topMap = new HashMap();
            HashMap secMap = new HashMap();
            HashMap secMapInfo = new HashMap();
            areaTreeRespDtoList.forEach(areaTreeRespDto -> {
                topMap.put(areaTreeRespDto.getCode(), areaTreeRespDto);
                if (areaTreeRespDto.getChildren() != null && !areaTreeRespDto.getChildren().isEmpty()) {
                    if (areaTreeRespDto.getCode().equals("110000000000") || areaTreeRespDto.getCode().equals("120000000000") || areaTreeRespDto.getCode().equals("310000000000") || areaTreeRespDto.getCode().equals("500000000000")) {
                        areaTreeRespDto.getChildren().forEach(secChild -> {
                            if (secChild.getChildren() != null && !secChild.getChildren().isEmpty()) {
                                secChild.getChildren().forEach(thirdChild -> {
                                    secMap.put(thirdChild.getCode(), areaTreeRespDto.getCode());
                                    secMapInfo.put(thirdChild.getCode(), thirdChild);
                                });
                            }
                        });
                    } else {
                        areaTreeRespDto.getChildren().forEach(childArea -> {
                            secMap.put(childArea.getCode(), areaTreeRespDto.getCode());
                            secMapInfo.put(childArea.getCode(), childArea);
                        });
                    }
                }
            });
            HashMap ruleAreaTopMap = new HashMap();
            ArrayList codeList = new ArrayList();
            ruleReqDtos.forEach(ruleReqDto -> {
                String areaText = ruleReqDto.getAreaCode();
                String[] areaCodes = areaText.split(",");
                if (areaCodes.length > 0) {
                    for (String areaCode : areaCodes) {
                        AreaTreeRespDto areaTreeRespDto;
                        if (StringUtils.isBlank((CharSequence)areaCode)) continue;
                        if (topMap.containsKey(areaCode)) {
                            if (ruleAreaTopMap.containsKey(areaCode)) {
                                areaTreeRespDto = (AreaTreeRespDto)topMap.get(areaCode);
                                throw new BizException(String.format("\u81f3\u5c11\u5b58\u57282\u4e2a\u3010%s\u3011", areaTreeRespDto.getName()));
                            }
                            ruleAreaTopMap.put(areaCode, ruleReqDto.getRuleCode());
                            continue;
                        }
                        if (codeList.contains(areaCode)) {
                            areaTreeRespDto = (AreaTreeRespDto)secMapInfo.get(areaCode);
                            throw new BizException(String.format("\u81f3\u5c11\u5b58\u57282\u4e2a\u3010%s\u3011", areaTreeRespDto.getName()));
                        }
                        String topCode = (String)secMap.get(areaCode);
                        if (ruleAreaTopMap.containsKey(topCode)) {
                            AreaTreeRespDto areaTreeRespDto2 = (AreaTreeRespDto)topMap.get(topCode);
                            throw new BizException(String.format("\u3010%s\u3011\u5305\u542b\u4e86\u3010%s\u3011", areaTreeRespDto2.getName(), ((AreaTreeRespDto)secMapInfo.get(areaCode)).getName()));
                        }
                        codeList.add(areaCode);
                    }
                }
            });
        }
        finally {
            this.logger.info("\u6821\u9a8c\u533a\u57df\u4e92\u65a5\u903b\u8f91:{}ms", (Object)(System.currentTimeMillis() - current));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFreeFreightRule(List<FreeFreightRuleReqDto> ruleReqDtos, List<AreaTreeRespDto> areaTreeRespDtoList) {
        if (ruleReqDtos == null || ruleReqDtos.isEmpty()) {
            return;
        }
        long current = System.currentTimeMillis();
        try {
            HashMap topMap = new HashMap();
            HashMap secMap = new HashMap();
            HashMap secMapInfo = new HashMap();
            areaTreeRespDtoList.forEach(areaTreeRespDto -> {
                topMap.put(areaTreeRespDto.getCode(), areaTreeRespDto);
                if (areaTreeRespDto.getChildren() != null && !areaTreeRespDto.getChildren().isEmpty()) {
                    if (areaTreeRespDto.getCode().equals("110000000000") || areaTreeRespDto.getCode().equals("120000000000") || areaTreeRespDto.getCode().equals("310000000000") || areaTreeRespDto.getCode().equals("500000000000")) {
                        areaTreeRespDto.getChildren().forEach(secChild -> {
                            if (secChild.getChildren() != null && !secChild.getChildren().isEmpty()) {
                                secChild.getChildren().forEach(thirdChild -> {
                                    secMap.put(thirdChild.getCode(), areaTreeRespDto.getCode());
                                    secMapInfo.put(thirdChild.getCode(), thirdChild);
                                });
                            }
                        });
                    } else {
                        areaTreeRespDto.getChildren().forEach(childArea -> {
                            secMap.put(childArea.getCode(), areaTreeRespDto.getCode());
                            secMapInfo.put(childArea.getCode(), childArea);
                        });
                    }
                }
            });
            HashMap ruleAreaTopMap = new HashMap();
            ArrayList codeList = new ArrayList();
            ruleReqDtos.forEach(ruleReqDto -> {
                String areaText = ruleReqDto.getAreaCode();
                String[] areaCodes = areaText.split(",");
                if (areaCodes.length > 0) {
                    for (String areaCode : areaCodes) {
                        AreaTreeRespDto areaTreeRespDto;
                        if (StringUtils.isBlank((CharSequence)areaCode)) continue;
                        if (topMap.containsKey(areaCode)) {
                            if (ruleAreaTopMap.containsKey(areaCode)) {
                                areaTreeRespDto = (AreaTreeRespDto)topMap.get(areaCode);
                                throw new BizException(String.format("\u81f3\u5c11\u5b58\u57282\u4e2a\u3010%s\u3011", areaTreeRespDto.getName()));
                            }
                            ruleAreaTopMap.put(areaCode, ruleReqDto.getRuleCode());
                            continue;
                        }
                        if (codeList.contains(areaCode)) {
                            areaTreeRespDto = (AreaTreeRespDto)secMapInfo.get(areaCode);
                            throw new BizException(String.format("\u81f3\u5c11\u5b58\u57282\u4e2a\u3010%s\u3011", areaTreeRespDto.getName()));
                        }
                        String topCode = (String)secMap.get(areaCode);
                        if (ruleAreaTopMap.containsKey(topCode)) {
                            AreaTreeRespDto areaTreeRespDto2 = (AreaTreeRespDto)topMap.get(topCode);
                            throw new BizException(String.format("\u3010%s\u3011\u5305\u542b\u4e86\u3010%s\u3011", areaTreeRespDto2.getName(), ((AreaTreeRespDto)secMapInfo.get(areaCode)).getName()));
                        }
                        codeList.add(areaCode);
                    }
                }
            });
        }
        finally {
            this.logger.info("\u6821\u9a8c\u533a\u57df\u4e92\u65a5\u903b\u8f91:{}ms", (Object)(System.currentTimeMillis() - current));
        }
    }

    private List<AreaTreeRespDto> getAreaTree(FreightTemplateReqDto freightTemplateReqDto) {
        List<AreaTreeRespDto> areaTreeRespDtoList = null;
        if (freightTemplateReqDto.getFreeFreightRuleList() != null && !freightTemplateReqDto.getFreeFreightRuleList().isEmpty() || freightTemplateReqDto.getFreightRuleList() != null && !freightTemplateReqDto.getFreightRuleList().isEmpty()) {
            areaTreeRespDtoList = this.getAreaTree();
        }
        return areaTreeRespDtoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AreaTreeRespDto> getAreaTree() {
        List<AreaTreeRespDto> areaTreeRespDtoList;
        long current = System.currentTimeMillis();
        try {
            areaTreeRespDtoList = AreaCache.AREA_TREE_CACHE;
        }
        finally {
            this.logger.info("\u4ece\u57fa\u7840\u5e73\u53f0\u83b7\u53d6\u533a\u57df\u4fe1\u606f\u7528\u65f6:{}ms", (Object)(System.currentTimeMillis() - current));
        }
        return areaTreeRespDtoList;
    }

    private FreightTemplateEo getEo(FreightTemplateReqDto freightTemplateReqDto) {
        return this.getEo(freightTemplateReqDto, true);
    }

    private FreightTemplateEo getEo(FreightTemplateReqDto freightTemplateReqDto, boolean isAdd) {
        FreightTemplateEo eo = FreightTemplateEo.newInstance();
        if (isAdd) {
            freightTemplateReqDto.setId(null);
            freightTemplateReqDto.setState(FreightTemplateState.ENABLE.getCode());
        }
        BeanUtil.copyProperties((Object)freightTemplateReqDto, (Object)eo, (String[])new String[0]);
        return eo;
    }

    @Override
    @Transactional
    public Boolean modify(FreightTemplateReqDto freightTemplateReqDto) {
        this.checkArea(freightTemplateReqDto);
        FreightTemplateEo freightTemplateEo = this.getEo(freightTemplateReqDto, false);
        FreightTemplateEo logEo = (FreightTemplateEo)this.freightTemplateDas.selectByPrimaryKey(freightTemplateReqDto.getId());
        if (logEo == null) {
            throw new BizException("\u9700\u8981\u4fdd\u5b58\u7684\u7684\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4");
        }
        freightTemplateEo.setState(logEo.getState());
        logEo.setCode(logEo.getCode() + "_" + System.currentTimeMillis());
        logEo.setDr(DrEnum.DELETED.getCode());
        logEo.setRemark(logEo.getId().toString());
        logEo.setName(logEo.getId().toString());
        logEo.setRemark("\u4fee\u6539\u5907\u4efd");
        logEo.setId(null);
        this.freightTemplateDas.insert((BaseEo)logEo);
        this.freightTemplateDas.update((BaseEo)freightTemplateEo);
        Long templateId = freightTemplateReqDto.getId();
        if (freightTemplateReqDto.getFreeFreight() != null && freightTemplateReqDto.getFreeFreight() == 1) {
            if (CollectionUtils.isEmpty((Collection)freightTemplateReqDto.getFreeFreightRuleList())) {
                throw new BizException("\u542f\u7528\u514d\u90ae\u89c4\u5219\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e00\u6761\u514d\u90ae\u89c4\u5219");
            }
        } else {
            freightTemplateReqDto.setFreeFreightRuleList(null);
        }
        this.freightRuleService.add(templateId, freightTemplateReqDto.getFreightRuleList());
        this.freeFreightRuleService.add(templateId, freightTemplateReqDto.getFreeFreightRuleList());
        return true;
    }

    @Override
    public Boolean delete(Long templateId) {
        FreightTemplateEo freightTemplateEo = FreightTemplateEo.newInstance();
        freightTemplateEo.setId(templateId);
        this.freightTemplateDas.logicDelete((BaseEo)freightTemplateEo);
        return true;
    }

    @Override
    public FreightTemplateRespDto getById(Long templateId, boolean needTree) {
        if (templateId == null) {
            return null;
        }
        FreightTemplateEo eo = (FreightTemplateEo)this.freightTemplateDas.selectByPrimaryKey(templateId);
        if (eo == null) {
            return null;
        }
        FreightTemplateRespDto dto = this.getDto(eo);
        List<FreeFreightRuleRespDto> freeRules = this.freeFreightRuleService.getRules(eo.getId(), needTree, needTree);
        List<FreightRuleRespDto> costRules = this.freightRuleService.getRules(eo.getId(), needTree, needTree);
        dto.setFreeFreightRuleList(freeRules);
        dto.setFreightRuleList(costRules);
        return dto;
    }

    private FreightTemplateRespDto getDto(FreightTemplateEo eo) {
        FreightTemplateRespDto dto = new FreightTemplateRespDto();
        BeanUtils.copyProperties((Object)eo, (Object)dto);
        dto.setId(eo.getId().toString());
        return dto;
    }

    private FreightTemplateSimpleRespDto getSimpleDto(FreightTemplateEo eo) {
        FreightTemplateSimpleRespDto dto = new FreightTemplateSimpleRespDto();
        BeanUtil.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        dto.setId(eo.getId().toString());
        return dto;
    }

    @Override
    public List<FreightTemplateRespDto> getByIds(List<Long> templateIds) {
        return null;
    }

    @Override
    public Boolean modifyTemplateState(Byte state, Long templateId) {
        FreightTemplateEo eo = FreightTemplateEo.newInstance();
        eo.setId(templateId);
        eo.setState(state);
        this.freightTemplateDas.updateSelective((BaseEo)eo);
        return true;
    }

    @Override
    public PageInfo<FreightTemplateSimpleRespDto> page(FreightTemplatePageReqDto pageReqDto) {
        FreightTemplateEo eo = FreightTemplateEo.newInstance();
        ArrayList filterLists = Lists.newArrayList();
        if (!StringUtils.isBlank((CharSequence)pageReqDto.getCode())) {
            filterLists.add(SqlFilter.like((String)"code", (Object)StringUtils.wrapIfMissing((String)pageReqDto.getCode(), (String)"%")));
        }
        if (!StringUtils.isBlank((CharSequence)pageReqDto.getName())) {
            filterLists.add(SqlFilter.like((String)"name", (Object)StringUtils.wrapIfMissing((String)pageReqDto.getName(), (String)"%")));
        }
        if (pageReqDto.getUpdateTimeStart() != null && pageReqDto.getUpdateTimeEnd() != null) {
            filterLists.add(SqlFilter.ge((String)"updateTime", (Object)pageReqDto.getUpdateTimeStart()));
            filterLists.add(SqlFilter.le((String)"updateTime", (Object)pageReqDto.getUpdateTimeEnd()));
        }
        if (pageReqDto.getState() != null) {
            filterLists.add(SqlFilter.eq((String)"state", (Object)pageReqDto.getState()));
        }
        if (pageReqDto.getType() != null && pageReqDto.getType() == 1) {
            filterLists.add(SqlFilter.in((String)"pricType", (Object)new byte[]{0, 1, 2}));
        }
        eo.setSqlFilters((List)filterLists);
        eo.setOrderByDesc("updateTime");
        PageInfo pageInfo = this.freightTemplateDas.selectPage((BaseEo)eo, pageReqDto.getPageNum(), pageReqDto.getPageSize(), Boolean.valueOf(false));
        List list = pageInfo.getList().stream().map(this::getSimpleDto).collect(Collectors.toList());
        PageInfo dtoPageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }
}

