/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.loyalty.request.MemberLevelDefineCreateReqDto;
import com.dtyunxi.yundt.cube.center.member.api.basis.IMemberApi;
import com.dtyunxi.yundt.cube.center.member.api.basis.IMemberModelApi;
import com.dtyunxi.yundt.cube.center.member.api.basis.dto.request.MemberModelReqDto;
import com.dtyunxi.yundt.cube.center.member.api.basis.dto.response.MemberModelRespDto;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberModelQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.MemberReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.response.MemberRespDto;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MemberModelProxy {
    @Resource
    private IMemberModelApi memberModelApi;
    @Resource
    private IMemberModelQueryApi modelQueryApi;
    @Resource
    private IMemberApi memberApi;
    @Resource
    private ShopDas shopDas;
    @Resource
    private IMemberQueryApi memberQueryApi;

    public long createMemberModel(String name, String remark, long tenantId, long instanceId) {
        RestResponse listRestResponse = this.modelQueryApi.queryList("{'name':'" + name + "'}");
        if (CollectionUtils.isNotEmpty((Collection)((Collection)listRestResponse.getData()))) {
            MemberModelRespDto memberModelDto = (MemberModelRespDto)((List)listRestResponse.getData()).get(0);
            return memberModelDto.getId();
        }
        MemberModelReqDto dto = new MemberModelReqDto();
        dto.setName(name);
        dto.setRemark(remark);
        ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(instanceId);
        dto.setInstanceIds(list);
        RestResponse memberModelId = this.memberModelApi.create(dto);
        return (Long)memberModelId.getData();
    }

    public void createMemberLevels(long shopId, List<MemberLevelDefineCreateReqDto> dtos) {
        ShopEo shopEo = this.validateShopId(shopId);
        long modelId = this.createMemberModel(shopEo);
        if (CollectionUtils.isNotEmpty(dtos)) {
            for (MemberLevelDefineCreateReqDto levelDefineReqDto : dtos) {
                levelDefineReqDto.setCode("level1");
                levelDefineReqDto.setMemberModelId(Long.valueOf(modelId));
            }
        }
    }

    public void createShopLevel(long tenantId, long instanceId, @NotNull List<MemberLevelDefineCreateReqDto> dtos) {
        long modelId = this.createMemberModel("tenant_seller", "\u5e73\u53f0\u5e97\u94fa\u7b49\u7ea7\u4f53\u7cfb", tenantId, instanceId);
        if (CollectionUtils.isNotEmpty(dtos)) {
            for (MemberLevelDefineCreateReqDto levelDefineReqDto : dtos) {
                levelDefineReqDto.setCode("level1");
                levelDefineReqDto.setMemberModelId(Long.valueOf(modelId));
            }
        }
    }

    public void addShopMember(long shopId, MemberReqDto dto) {
        ShopEo shopEo = this.validateShopId(shopId);
        long modelId = this.createMemberModel(shopEo);
        dto.setModelId(Long.valueOf(modelId));
        dto.setGrowthValue(0);
        this.memberApi.bind(dto.getInstanceId(), dto.getUserId(), dto);
    }

    private long createMemberModel(ShopEo shopEo) {
        return this.createMemberModel("shop_member" + shopEo.getId(), "\u5e97\u94fa" + shopEo.getName() + "\u4f1a\u5458\u7b49\u7ea7", shopEo.getTenantId(), shopEo.getInstanceId());
    }

    private ShopEo validateShopId(long shopId) {
        ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(Long.valueOf(shopId));
        if (null == shopEo) {
            throw new CubeException(ExceptionCode.INVALID_PARAM.getCode(), "shopId\u53c2\u6570\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e97\u94fa");
        }
        return shopEo;
    }

    public void delShopMember(long shopId, long userId) {
        ShopEo shopEo = this.validateShopId(shopId);
        long modelId = this.createMemberModel(shopEo);
        RestResponse memberDtoRestResponse = this.memberQueryApi.queryMemberByModelIdAndUserId(Long.valueOf(modelId), Long.valueOf(userId));
        if (null != memberDtoRestResponse.getData()) {
            long memberId = ((MemberRespDto)memberDtoRestResponse.getData()).getId();
            this.memberApi.cancel(Long.valueOf(memberId));
        }
    }
}

