package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import java.lang.reflect.Field;
import java.util.*;

public class GenerateUtil {
    public static <T> T generateBean(Class<T> clazz) throws Exception {
        List<Field> fieldList = new ArrayList<>();
        Class tmp = clazz;
        while (tmp != null) {
            fieldList.addAll(Arrays.asList(tmp.getDeclaredFields()));
            tmp = tmp.getSuperclass();
        }

        Object obj = Class.forName(clazz.getName()).newInstance();

        for (Field declaredField : fieldList) {
            declaredField.setAccessible(true);
            Class<?> type = declaredField.getType();
            if(String.class.getTypeName().equals(type.getTypeName())){
                declaredField.set(obj, generateString());
            }else if(Integer.class.getTypeName().equals(type.getTypeName())){
                declaredField.set(obj, 1);
            }else if(Date.class.getTypeName().equals(type.getTypeName())){
                declaredField.set(obj, new Date());
            }
        }
        return (T)obj;
    }

    private static String generateString(){
        return generateString(5);
    }

    private static String generateString(int length){
        char[] chars = {'床','前','明','月','光','疑','是','地','上','霜','举','头','望','明','月','低','头','思','故','乡'};
        Random random = new Random();

        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; i++) {
            builder.append(chars[random.nextInt(chars.length)]);
        }
        return builder.toString().intern();
    }
}
