/*
 * @(#)IItemApi.java 1.0 2018-08-22
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.ChannelItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;

/**
 * 渠道商品服务接口
 *
 * @author chunjiu
 * @since 2.0.0
 */

@Api(tags = {"商品中心：渠道商品服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId="com-dtyunxi-yundt-cube-center-item-api-base-IChannelItemApi",
        path = "/v1/channel/item",
        url = "${yundt.cube.center.item.api:}")
public interface IChannelItemApi {
    /**
     * 新增渠道商品
     *
     * @param channelItemReqDto 渠道商品实体对象
     * @return 统一返回响应对象，业务数据data为新增后的渠道商品Id
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增渠道商品", notes = "新增渠道商品")
    RestResponse<Long> addChannelItem(@Validated @RequestBody ChannelItemReqDto channelItemReqDto);

    /**
     * 更新渠道商品
     *
     * @param channelItemReqDto 渠道商品实体对象
     * @return Void
     */
    @PutMapping("/modify")
    @ApiOperation(value = "更新渠道商品", notes = "更新渠道商品")
    RestResponse<Void> modifyChannelItem(@Validated @RequestBody ChannelItemReqDto channelItemReqDto);

    /**
     * 更新渠道商品状态
     *
     * @param id     渠道商品Id
     * @param status 状态
     * @return 统一返回响应对象，业务数据data为更新后的渠道商品Id
     */
    @PutMapping(value = "/{id}/status/{status}")
    @ApiOperation(value = "更新渠道商品状态", notes = "更新渠道商品状态 \n id:渠道商品id status:状态(0-待提交；1-待审核；2-待上架；3-已上架；4-已下架；5-审核不通过)")
    RestResponse<Long> modifyStatus(@NotNull(message = "渠道商品Id不能为空") @PathVariable("id") Long id,
                                    @NotNull(message = "要修改不能为空") @PathVariable("status") Integer status);

    /**
     * 审核渠道商品
     *
     * @param id 渠道商品Id
     * @return Void
     */
    @PutMapping("/audit")
    @ApiOperation(value = "审核渠道商品", notes = "审核渠道商品")
    RestResponse<Void> auditChannelItem(@NotNull(message = "渠道商品Id不能为空") @PathVariable("id") Long id);
}
