/*
 * @(#)IItemApi.java 1.0 2018-08-22
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 商品接口
 *
 * @author 诺克 双清
 * @since 2.0.0
 */

@Api(tags = {"商品中心：全渠道商品服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId="com-dtyunxi-yundt-cube-center-item-api-omnichannel-IItemOmniChannelApi",
        path = "/v1/item",
        url = "${yundt.cube.center.item.api:}")
public interface IItemOmniChannelApi {

    /**
     * 更新是否线下可售，是否线下可售，0-否，1-是
     */
    @PostMapping(value = "/updateAvailableOffline/{skuId}/{ifAvailableOffline}")
    @ApiOperation(value = "更新是否线下可售", notes = "更新是否线下可售")
    RestResponse<Void> updateAvailableOffline(@PathVariable("skuId") Long skuId,
                                              @PathVariable("ifAvailableOffline") Integer ifAvailableOffline);

}
