package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageOnOrOffSalesReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 套餐商品表服务接口
 *
 * @author shuchi
 * @since 2020-10-19
 */
@Api(tags = {"套餐商品表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/package",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPackageApi {

    /**
     * 新增套餐商品表
     *
     * @param addReqDto 套餐商品表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增套餐商品表", notes = "新增套餐商品表")
    RestResponse<Long> addPackage(@Valid @RequestBody PackageReqDto addReqDto);

    /**
     * 修改套餐商品表
     *
     * @param modifyReqDto 套餐商品表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改套餐商品表", notes = "修改套餐商品表")
    RestResponse<Void> modifyPackage(@RequestBody PackageReqDto modifyReqDto);

    /**
     * 删除套餐商品表
     *
     * @param ids 套餐商品表删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除套餐商品表", notes = "删除套餐商品表")
    RestResponse<Void> removePackage(@PathVariable("ids") String ids);


    /**
     * 批量上架套餐
     *
     * @param packageOnOrOffSalesReqDto 套餐集合
     * @return 处理结果
     */
    @PostMapping("/onSalesOrNot")
    @ApiOperation(value = "批量上架套餐", notes = "批量上架套餐")
    RestResponse<Void> onSalesOrNot(@RequestBody PackageOnOrOffSalesReqDto packageOnOrOffSalesReqDto);


}
