package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.ItemRelationComparisonReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 商品关系对照Api
 *
 * @Interface ItemRelationComparisonApi
 * @Author chunjiu
 * @Date 2020/12/23 15:32
 */
@Api(tags = {"商品中心：商品关系对照"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId="com-dtyunxi-yundt-cube-center-item-api-base-IItemRelationComparisonApi",
        path = "/v1/item/relation",
        url = "${yundt.cube.center.item.api:}")
public interface IItemRelationComparisonApi {

    /**
     * 新增商品关系对照记录
     *
     * @param itemRelationComparisonReqDto 商品关系对照请求dto
     * @return
     **/
    @PostMapping(value = "/add")
    @ApiOperation(value = "新增商品关系对照记录", notes = "新增查询商品关系对照记录")
    RestResponse<Void> addItemRelationComparison(@RequestBody ItemRelationComparisonReqDto itemRelationComparisonReqDto);

    /**
     * 修改商品关系对照记录
     *
     * @param itemRelationComparisonReqDto 商品关系对照请求dto
     * @return
     **/
    @PutMapping(value = "/modify")
    @ApiOperation(value = "修改商品关系对照记录", notes = "修改商品关系对照记录")
    RestResponse<Void> modifyItemRelationComparison(@RequestBody ItemRelationComparisonReqDto itemRelationComparisonReqDto);

    /**
     * 批量操作商品关系对照记录
     *
     * @param flag 操作标识
     * @param ids 批量id
     * @return
     **/
    @ApiOperation("批量操作商品关系对照记录")
    @PutMapping("/{flag}/{ids}")
    RestResponse<Void> operateByIds(@PathVariable("flag") Integer flag, @PathVariable("ids") String ids);
}
