/**
 * @(#) IItemQueryApi.java 1.0 2018-08-22
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.omnichannel;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.SyncChannelItemUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author chunjiui
 * @since 1.0.0
 */
@Api(tags = {"商品中心：渠道商品查询服务sync"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-ISyncChannelItemQueryApi",
        path = "/v1/item/syncChannelItem",
        url = "${yundt.cube.center.item.api:}")
public interface ISyncChannelItemApi {
    /**
     * 拉取渠道商品
     * @return
     */
    @GetMapping(value = "/fetch")
    @ApiOperation(value = "拉取渠道商品", notes = "拉取渠道商品")
    RestResponse<Void> fetch();

    /**
     * 商品标题、图片、价格、上架状态修改
     * @param syncChannelItemUpdateReqDtos
     * @return
     **/
    @PutMapping(value = "/update")
    @ApiOperation(value = "商品标题、图片、价格、上架状态修", notes = "商品标题、图片、价格、上架状态修")
    RestResponse<Void> update(@RequestBody List<SyncChannelItemUpdateReqDto> syncChannelItemUpdateReqDtos);
}
