package com.dtyunxi.yundt.cube.center.item.api.omnichannel.constants;

/**
 * 渠道状态
 *
 * @Enum ChannelItemStatusEnum
 * @Author chunjiu
 * @Date 2021/1/25 16:40
 */
public enum ChannelItemStatusEnum {
    /**
     *  商品枚举
     */
    CHANNEL_ITEM_TO_SUBMIT(0, "待提交"),
    CHANNEL_ITEM_TO_AUDIT(1, "待审核"),
    CHANNEL_ITEM_TO_ONSHELF(2, "待上架"),
    CHANNEL_ITEM_ONSHELF(3, "已上架"),
    CHANNEL_ITEM_OFFSHELF(4, "已下架"),
    CHANNEL_ITEM_AUDIT_FAIL(5, "审核不通过");

    private Integer status;
    private String desc;

    ChannelItemStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDesc(Integer index) {
        for (ChannelItemStatusEnum statusEnum : ChannelItemStatusEnum.values()) {
            if (statusEnum.getStatus().equals(index)) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
