/*
 * @(#)FlowMessageTag.java 1.0 2018-11-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.omnichannel.constants;

/**
 * 消息的tag名称
 *
 * @author 简树
 * @since 2.0.0
 */
public interface MessageTag {
    /**
     * 订单发货(跟库存中心重复，会抢消息)
     */
    String ORDER_DELIVERY = "order_delivery2";
    /**
     * 订单发货-消息发送
     */
    String PRODUCER_ORDER_DELIVERY_WAIT_DELIVERY = "order_delivery2_wait_delivery";
    /**
     * 订单发货-消息接收
     */
    String CUSTOMER_ORDER_DELIVERY_CONFIRM_DELIVERY = "order_delivery2_confirm_delivery";
    //String ORDER_DELIVERY="order_delivery5";
    /**
     * 出库消息
     */
    String DELIVERY_STORAGE_OUT = "delivery_storage_out3";
    //String DELIVERY_STORAGE_OUT = "delivery_storage_out5";
    /**
     * 订单虚拟商品库存变更TAG
     */
    String VIRTUAL_TRADE_ORDER_STORAGE_CHANGE = "VIRTUAL_TRADE_ORDER_STORAGE_CHANGE";

    /**
     * 订单状态变更
     */
    String ORDER_STATUS_CHANGE = "order_status_change";
    /**
     * 订单同步
     */
    String SECKILL_SUBMIT_ORDER = "seckill_submit_order";

    /**
     * 订单同步
     */
    String ORDER = "ORDER";
    /**
     * 订单交易状态变更
     */
    String ORDER_TRADE_STATUS_CHANGE = "order_trade_status_change";
    /**
     * 订单取消变更
     */
    String ORDER_TRADE_CANCEL_CHANGE = "order_trade_cancel_change";
    /**
     * 活动订单操作
     */
    String ACTIVITY_GROUP_ORDER_OPERATE = "ACTIVITY_GROUP_ORDER_OPERATE";

    /**
     * 连接器发货单同步tag
     */
    String CONNECTOR_DELIVERY_SYNC = "delivery";

    /**
     * 连接器售后单同步
     */
    String RETURN_ORDER = "returnOrder";

    /**
     * 连接器发送消息到中心的tag，订单发送
     */
    public static final String TAG_ORDER = "order";

    /**
     * 连接器发送消息到中心的tag，售后单发送
     */
    public static final String TAG_REFUND = "refund";

    /**
     * 连接器发送消息到中心的tag，商品发送
     */
    public static final String TAG_ITEM = "item";

    /**
     * 连接器发货信息回传TAG
     */
    String WMS_DELIVERY_PASS_BACK = "wmsDeliveryPassBack";
    String DELIVER_CALL_BACK = "deliverCallBack";

    /**
     * 订单支付成功
     */
    String ORDER_PAY_SUCCESS = "order_pay_success";

    /**
     * 商城订单生成发货单tag
     */
    String GENERATE_DELIVERY_TAG = "GENERATE_DELIVERY_TAG" ;

    /**
     * 确认收货发货单tag
     */
    String CONFIRM_RECEIPT_DELIVERY_TAG = "CONFIRM_RECEIPT_DELIVERY_TAG";

    /**
     * 同步发货单到库存中心TAG
     */
    String INVENTORY_DELIVERY_TAG = "INVENTORY_DELIVERY_TAG";

    /**
     * 发货单确认收货
     */
    String DELIVERY_ORDER_DELIVERY_TAG = "DELIVERY_ORDER_DELIVERY_TAG";

    /**
     * 发货单确认收货
     */
    String CONFIRM_ORDER_DELIVERY_TAG = "CONFIRM_ORDER_DELIVERY_TAG";

    /**
     * 达达物流消息通知
     */
    String DADA_DELIVERY_ORDER_NOTIFY_TAG = "DADA_DELIVERY_ORDER_NOTIFY_TAG";

}
