package com.dtyunxi.yundt.cube.center.item.api.omnichannel.constants;

public interface SyncChannelItemEnum {
    enum ChannelItemStatusEnum {
        /**
         * 渠道商品状态0-下架1-上架
         */
        ON(1, "上架"),
        OFF(0, "下架"),
        ;

        private Integer status;
        private String desc;

        ChannelItemStatusEnum(Integer status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public static String getDesc(Integer index) {
            for (ChannelItemStatusEnum statusEnum : ChannelItemStatusEnum.values()) {
                if (statusEnum.getStatus().equals(index)) {
                    return statusEnum.getDesc();
                }
            }
            return null;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    enum ComparisonStatusEnum {
        /**
         * 商品对照状态0-否1-是
         */
        YES(1, "是"),
        NO(0, "否"),
        ;

        private Integer status;
        private String desc;

        ComparisonStatusEnum(Integer status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public static String getDesc(Integer index) {
            for (ComparisonStatusEnum statusEnum : ComparisonStatusEnum.values()) {
                if (statusEnum.getStatus().equals(index)) {
                    return statusEnum.getDesc();
                }
            }
            return null;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}
