package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 渠道商品请求Dto
 *
 * @author chunjiu
 * @since 2.0.0
 */
@ApiModel(value = "ChannelItemReqDto", description = "渠道商品请求Dto")
public class ChannelItemReqDto extends BaseReqDto {

    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id，不填")
    private Long id;
    /**
     * 渠道id
     */
    @ApiModelProperty(name = "channelId", value = "渠道id")
    private Long channelId;
    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "channelName", value = "渠道名称")
    private String channelName;
    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * sku的编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku的编码")
    private String skuCode;
    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;
    /**
     * 零售价
     */
    @ApiModelProperty(name = "shoretallPriceId", value = "零售价")
    private BigDecimal retallPrice;
    /**
     * 渠道商品状态；0-待提交；1-待审核；2-待上架；3-已上架；4-已下架；5-审核不通过
     */
    @ApiModelProperty(name = "status", value = "渠道商品状态；0-待提交；1-待审核；2-待上架；3-已上架；4-已下架；5-审核不通过")
    private Integer status;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "目录Id")
    private Long dirId;

    /**
     * 更新时间（开始）
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间（开始）")
    private String updateTimeStart;

    /**
     * 更新时间（结束）
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间（结束）")
    private String updateTimeEnd;

    /**
     * 最低价格
     */
    @ApiModelProperty(name = "lowestPrice", value = "最低价格")
    private String lowestPrice;

    /**
     * 最高价格
     */
    @ApiModelProperty(name = "highestPrice", value = "最高价格")
    private String highestPrice;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getRetallPrice() {
        return retallPrice;
    }

    public void setRetallPrice(BigDecimal retallPrice) {
        this.retallPrice = retallPrice;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getLowestPrice() {
        return lowestPrice;
    }

    public void setLowestPrice(String lowestPrice) {
        this.lowestPrice = lowestPrice;
    }

    public String getHighestPrice() {
        return highestPrice;
    }

    public void setHighestPrice(String highestPrice) {
        this.highestPrice = highestPrice;
    }
}
