package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品关系对照表请求Dto
 *
 * @ClassName ItemRelationComparisonReqDto
 * @Author chunjiu
 * @Date 2020/12/23 14:39
 */
@ApiModel(value = "ItemRelationComparisonReqDto", description = "商品关系对照表请求Dto")
public class ItemRelationComparisonReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     * 对照类型
     */
    @ApiModelProperty(name = "relationType", value = "对照类型")
    private Integer relationType;

    /**
     * 所属渠道编码
     */
    @ApiModelProperty(name = "channelCode", value = "所属渠道编码")
    private String channelCode;

    /**
     * 所属渠道名称
     */
    @ApiModelProperty(name = "channelName", value = "所属渠道名称")
    private String channelName;

    /**
     * 所属店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "所属店铺编码")
    private String shopCode;

    /**
     * 渠道商品编码
     */
    @ApiModelProperty(name = "channelItemCode", value = "渠道商品编码")
    private String channelItemCode;

    /**
     * 渠道sku编码
     */
    @ApiModelProperty(name = "channelSkuCode", value = "渠道sku编码")
    private String channelSkuCode;

    /**
     * 渠道商品名称
     */
    @ApiModelProperty(name = "channelItemName", value = "渠道商品名称")
    private String channelItemName;

    /**
     * 渠道状态，0-关闭，1-开启
     */
    @ApiModelProperty(name = "channelStatus", value = "渠道状态，0-关闭，1-开启")
    private Integer channelStatus;

    /**
     * 渠道备注
     */
    @ApiModelProperty(name = "channelRemark", value = "渠道备注")
    private String channelRemark;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     * sku编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    /**
     * 更新时间（开始）
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间（开始）")
    private String updateTimeStart;

    /**
     * 更新时间（结束）
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间（结束）")
    private String updateTimeEnd;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelItemCode() {
        return channelItemCode;
    }

    public void setChannelItemCode(String channelItemCode) {
        this.channelItemCode = channelItemCode;
    }

    public String getChannelItemName() {
        return channelItemName;
    }

    public void setChannelItemName(String channelItemName) {
        this.channelItemName = channelItemName;
    }

    public Integer getChannelStatus() {
        return channelStatus;
    }

    public void setChannelStatus(Integer channelStatus) {
        this.channelStatus = channelStatus;
    }

    public String getChannelRemark() {
        return channelRemark;
    }

    public void setChannelRemark(String channelRemark) {
        this.channelRemark = channelRemark;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getChannelSkuCode() {
        return channelSkuCode;
    }

    public void setChannelSkuCode(String channelSkuCode) {
        this.channelSkuCode = channelSkuCode;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
}
