package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 套餐商品表Eo对象
 *
 * @author shuchi
 * @since 2020-10-19
 */
@ApiModel(value = "PackageReqDto", description = "套餐商品表Eo对象")
public class PackageReqDto extends RequestDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     * 上架状态
     */
    @ApiModelProperty(name = "status", value = "上架状态 0:未上架 1:已上架")
    private Integer status;
    /**
     * 套餐价格
     */
    @ApiModelProperty(name = "price", value = "套餐价格")
    @NotNull(message = "套餐价格必填")
    private BigDecimal price;

    @ApiModelProperty(name = "packageShelfReqDtos", value = "上架集合")
    List<RPackageShelfReqDto> packageShelfReqDtos;

    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    @NotNull(message = "店铺编码不能为空")
    private String shopCode;


    @ApiModelProperty(name = "imageUrls", value = "图片地址")
    private List<String> imageUrls;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    @ApiModelProperty(name = "introduction", value = "介绍")
    private String introduction;

    @ApiModelProperty(name = "quantityLimit", value = "限购数量")
    private Integer quantityLimit;

    @ApiModelProperty(name = "isLimited", value = "是否限制单用户限购数量 否:0;是:1")
    private Integer isLimited;

    @ApiModelProperty(name = "currentStock", value = "当前库存数")
    private Integer currentStock;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public List<RPackageShelfReqDto> getPackageShelfReqDtos() {
        return packageShelfReqDtos;
    }

    public void setPackageShelfReqDtos(List<RPackageShelfReqDto> packageShelfReqDtos) {
        this.packageShelfReqDtos = packageShelfReqDtos;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public List<String> getImageUrls() {
        return imageUrls;
    }

    public void setImageUrls(List<String> imageUrls) {
        this.imageUrls = imageUrls;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public Integer getQuantityLimit() {
        return quantityLimit;
    }

    public void setQuantityLimit(Integer quantityLimit) {
        this.quantityLimit = quantityLimit;
    }

    public Integer getIsLimited() {
        return isLimited;
    }

    public void setIsLimited(Integer isLimited) {
        this.isLimited = isLimited;
    }

    public Integer getCurrentStock() {
        return currentStock;
    }

    public void setCurrentStock(Integer currentStock) {
        this.currentStock = currentStock;
    }
}
