package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 套餐商品表Eo对象
 *
 * @author shuchi
 * @since 2020-10-19
 */
@ApiModel(value = "PackageShelfQueryReqDto", description = "套餐商品表Eo对象")
public class PackageShelfQueryReqDto extends RequestDto {

    private Long id;

    private Long instanceId;

    private Long tenantId;

    private Long shopId;

    private Long shopName;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private Integer itemStatus;

    private String skuCode;

    private Boolean sellOut;

    private Date updateTime;

    private String brand;

    /**
     * 查询数据分组方式：1 shopId+itemId;2 itemId
     */
    private Integer groupBy;

    /**
     * 店铺ids
     */
    private List<Long> shopIds;

    /**
     * 品牌ids
     */
    private List<Long> brandIds;

    /**
     * 商户id
     */
    private Long sellerId;

    /**
     * 上架类型：1 普通上架  2 周期购上架
     */
    private Integer shelfType;

    /**
     * 类别
     */
    private String category;

    /**
     * 上架id集合
     */
    private Set<Long> shelfIds;

    /**
     * 规格名称
     */
    private String skuName;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 上架状态
     */
    private Integer status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopName() {
        return shopName;
    }

    public void setShopName(Long shopName) {
        this.shopName = shopName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Boolean getSellOut() {
        return sellOut;
    }

    public void setSellOut(Boolean sellOut) {
        this.sellOut = sellOut;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getGroupBy() {
        return groupBy;
    }

    public void setGroupBy(Integer groupBy) {
        this.groupBy = groupBy;
    }

    public List<Long> getShopIds() {
        return shopIds;
    }

    public void setShopIds(List<Long> shopIds) {
        this.shopIds = shopIds;
    }

    public List<Long> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(List<Long> brandIds) {
        this.brandIds = brandIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }


    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }


    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Set<Long> getShelfIds() {
        return shelfIds;
    }

    public void setShelfIds(Set<Long> shelfIds) {
        this.shelfIds = shelfIds;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
