/**
 * @(#)ItemShelfRespDto.java 1.0 2020/1/8
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品上架信息响应dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "PackageItemRespDto", description = "商品上架信息响应dto")
public class PackageItemRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     * 编码
     */
    @ApiModelProperty(name = "itemCode", value = "编码")
    private String itemCode;

    /**
     * sku名称
     */
    @ApiModelProperty(name = "skuName", value = "sku名称")
    private String skuName;

    @ApiModelProperty(name = "status", value = "0 待上架 1已上架")
    private Integer status;


    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;

    /**
     * 数量
     */
    @ApiModelProperty(name = "amount", value = "数量")
    private Long amount;

    /**
     * 分类
     */
    @ApiModelProperty(name = "category", value = "分类")
    private String category;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "imagePath", value = "图片链接")
    private String imagePath;

    @ApiModelProperty(name = "skuId", value = "规格id")
    private Long skuId;

    /**
     * 发票价格
     */
    @ApiModelProperty(name = "invoicePrice", value = "发票价格")
    private BigDecimal invoicePrice;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private String itemType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getImagePath() {
        return imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public BigDecimal getInvoicePrice() {
        return invoicePrice;
    }

    public void setInvoicePrice(BigDecimal invoicePrice) {
        this.invoicePrice = invoicePrice;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }
}
