package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
* 套餐商品表Eo对象
*
* @author shuchi
* @since 2020-10-19
*/
@ApiModel(value = "PackageRespDto", description = "套餐商品表Eo对象")
public class PackageRespDto extends BaseRespDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  编码
    */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
    *  店铺id
    */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
    *  上架状态
    */
    @ApiModelProperty(name = "status", value = "上架状态")
    private Integer status;
    /**
    *  套餐价格
    */
    @ApiModelProperty(name = "price", value = "套餐价格")
    private BigDecimal price;

    @ApiModelProperty(name = "savingMoney", value = "节省费用")
    private BigDecimal costSaving;

    @ApiModelProperty(name = "itemShelfRespDtos", value = "上架商品")
    private List<PackageItemRespDto> packageItemRespDtos;

    @ApiModelProperty(name = "imageUrls", value = "图片地址")
    private List<String> imageUrls;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    @ApiModelProperty(name = "introduction", value = "介绍")
    private String introduction;

    @ApiModelProperty(name = "quantityLimit", value = "限购数量")
    private Integer quantityLimit;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "markCollect", value = "收藏标记符")
    private Integer markCollect;

    @ApiModelProperty(name = "isLimited", value = "是否限制单用户限购数量 否:0;是:1")
    private Integer isLimited;

    @ApiModelProperty(name = "currentStock", value = "当前库存数")
    private Integer currentStock;

    public Integer getMarkCollect() {
        return markCollect;
    }

    public void setMarkCollect(Integer markCollect) {
        this.markCollect = markCollect;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setPrice(BigDecimal price){
    this.price = price;
    }
    public BigDecimal getPrice(){
    return this.price;
    }

    public List<PackageItemRespDto> getPackageItemRespDtos() {
        return packageItemRespDtos;
    }

    public void setPackageItemRespDtos(List<PackageItemRespDto> packageItemRespDtos) {
        this.packageItemRespDtos = packageItemRespDtos;
    }

    public List<String> getImageUrls() {
        return imageUrls;
    }

    public void setImageUrls(List<String> imageUrls) {
        this.imageUrls = imageUrls;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public Integer getQuantityLimit() {
        return quantityLimit;
    }

    public void setQuantityLimit(Integer quantityLimit) {
        this.quantityLimit = quantityLimit;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public BigDecimal getCostSaving() {
        return costSaving;
    }

    public void setCostSaving(BigDecimal costSaving) {
        this.costSaving = costSaving;
    }

    public Integer getIsLimited() {
        return isLimited;
    }

    public void setIsLimited(Integer isLimited) {
        this.isLimited = isLimited;
    }

    public Integer getCurrentStock() {
        return currentStock;
    }

    public void setCurrentStock(Integer currentStock) {
        this.currentStock = currentStock;
    }
}
