package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 渠道商品响应Dto
 *
 * @author chunjiu
 * @since 2.0.0
 */
@ApiModel(value = "SyncChannelItem4SingleItemRespDto", description = "渠道商品响应Dto")
public class SyncChannelItem4SingleItemRespDto extends BaseRespDto {
    @ApiModelProperty(name = "id", value = "ID")
    private Long id;

    @ApiModelProperty(name = "channelCode", value = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "channelName", value = "渠道名称")
    private String channelName;

    @ApiModelProperty(name = "channelId", value = "渠道ID")
    private Long channelId;

    @ApiModelProperty(name = "channelPic", value = "渠道标识（图片地址）")
    private String channelPic;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "channelItemCode", value = "渠道商品编码")
    private String channelItemCode;

    @ApiModelProperty(name = "channelItemName", value = "渠道商品名称")
    private String channelItemName;

    @ApiModelProperty(name = "channelItemMainPic", value = "渠道商品图片（主图）")
    private String channelItemMainPic;

    @ApiModelProperty(name = "channelItemNotMainPic", value = "渠道商品图片（非主图）")
    private String channelItemNotMainPic;

    @ApiModelProperty(name = "originChannelItemMainPic", value = "原渠道商品图片（主图）")
    private String originChannelItemMainPic;

    @ApiModelProperty(name = "originChannelItemNotMainPic", value = "原渠道商品图片（非主图）")
    private String originChannelItemNotMainPic;

    @ApiModelProperty(name = "channelItemStatus", value = "渠道商品状态0-下架1-上架")
    private Integer channelItemStatus;

    @ApiModelProperty(name = "comparisonStatus", value = "商品对照状态0-否1-是")
    private Integer comparisonStatus;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemCode", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;

    @ApiModelProperty(name = "quantity", value = "库存数量")
    private Integer quantity;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private String itemType;

    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;

    @ApiModelProperty(name = "categoryName", value = "类目名称")
    private String categoryName;

    @ApiModelProperty(name = "propsName", value = "属性规格")
    private String propsName;

    @ApiModelProperty(name = "syncChannelItemSkuRespDto", value = "SKU信息")
    private List<SyncChannelItemSkuRespDto> itemSku;

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelPic() {
        return channelPic;
    }

    public void setChannelPic(String channelPic) {
        this.channelPic = channelPic;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getChannelItemCode() {
        return channelItemCode;
    }

    public void setChannelItemCode(String channelItemCode) {
        this.channelItemCode = channelItemCode;
    }

    public String getChannelItemName() {
        return channelItemName;
    }

    public void setChannelItemName(String channelItemName) {
        this.channelItemName = channelItemName;
    }

    public String getChannelItemMainPic() {
        return channelItemMainPic;
    }

    public void setChannelItemMainPic(String channelItemMainPic) {
        this.channelItemMainPic = channelItemMainPic;
    }

    public Integer getChannelItemStatus() {
        return channelItemStatus;
    }

    public void setChannelItemStatus(Integer channelItemStatus) {
        this.channelItemStatus = channelItemStatus;
    }

    public Integer getComparisonStatus() {
        return comparisonStatus;
    }

    public void setComparisonStatus(Integer comparisonStatus) {
        this.comparisonStatus = comparisonStatus;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public List<SyncChannelItemSkuRespDto> getItemSku() {
        return itemSku;
    }

    public void setItemSku(List<SyncChannelItemSkuRespDto> itemSku) {
        this.itemSku = itemSku;
    }

    public String getChannelItemNotMainPic() {
        return channelItemNotMainPic;
    }

    public void setChannelItemNotMainPic(String channelItemNotMainPic) {
        this.channelItemNotMainPic = channelItemNotMainPic;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getPropsName() {
        return propsName;
    }

    public void setPropsName(String propsName) {
        this.propsName = propsName;
    }

    public String getOriginChannelItemMainPic() {
        return originChannelItemMainPic;
    }

    public void setOriginChannelItemMainPic(String originChannelItemMainPic) {
        this.originChannelItemMainPic = originChannelItemMainPic;
    }

    public String getOriginChannelItemNotMainPic() {
        return originChannelItemNotMainPic;
    }

    public void setOriginChannelItemNotMainPic(String originChannelItemNotMainPic) {
        this.originChannelItemNotMainPic = originChannelItemNotMainPic;
    }
}
