package com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 渠道商品管理可用店铺响应Dto
 *
 * @author chunjiu
 * @since 2.0.0
 */
@ApiModel(value = "ValidShops4ItemManageRespDto", description = "渠道商品管理响应Dto")
public class ValidShops4ItemManageRespDto extends BaseRespDto {
    @ApiModelProperty(
            name = "id",
            value = "店铺ID"
    )
    private Long id;
    @ApiModelProperty(
            name = "tenantId",
            value = "租户ID"
    )
    private Long tenantId;
    @ApiModelProperty(
            name = "instanceId",
            value = "实例ID"
    )
    private Long instanceId;
    @ApiModelProperty(
            name = "sellerId",
            value = "商户ID，必填",
            required = true
    )
    @NotNull(
            message = "商户ID不允许为空"
    )
    private Long sellerId;
    @ApiModelProperty(
            name = "code",
            value = "店铺编码，选填。如果没有提供，店铺中心生成分布式ID作为店铺编码"
    )
    private String code;
    @ApiModelProperty(
            name = "name",
            value = "店铺名称，必填",
            required = true
    )
    private String name;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
