/**
 * @(#) IItemQueryApi.java 1.0 2018-08-22
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.omnichannel.query;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.ChannelItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author chunjiui
 * @since 1.0.0
 */
@Api(tags = {"商品中心：渠道商品查询服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IChannelItemQueryApi",
        path = "/v1/channel/item",
        url = "${yundt.cube.center.item.api:}")
public interface IChannelItemQueryApi {
    /**
     * 根据ID主键查询渠道商品
     *
     * @param id 主键
     * @return RestResponse<ChannelItemRespDto>
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "根据Id查询渠道商品信息", notes = "根据Id查询渠道商品信息 \t\n id:渠道商品Id")
    RestResponse<ChannelItemRespDto> queryById(@PathVariable("id") Long id);


    /**
     * 分页查询渠道商品列表 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfo < ChannelItemRespDto>>
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询渠道商品分页列表", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<PageInfo<ChannelItemRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
