package com.dtyunxi.yundt.cube.center.item.api.omnichannel.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageShelfCountRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 套餐商品表服务接口
 *
 * @author shuchi
 * @since 2020-10-19
 */
@Api(tags = {"套餐商品表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/package",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPackageQueryApi {


    @GetMapping("/queryStatus/{id}")
    @ApiOperation(value = "根据id查询套餐商品表", notes = "根据id查询套餐商品表")
    RestResponse<Integer> queryStatusById(@PathVariable("id") Long id);


    /**
     * 根据id查询套餐商品表
     *
     * @param id         套餐商品表id
     * @param searchType
     * @return 套餐商品表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询套餐商品表", notes = "根据id查询套餐商品表")
    RestResponse<PackageRespDto> queryById(@PathVariable("id") Long id, @RequestParam(value = "searchType", required = false) String searchType);

    /**
     * 套餐商品表分页数据
     *
     * @param packageReqDto 套餐商品表查询条件
     * @param pageNum       当前页
     * @param pageSize      页大小
     * @return 套餐商品表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "套餐商品表分页数据", notes = "根据filter查询条件查询套餐商品表数据，filter=PackageReqDto")
    RestResponse<PageInfo<PackageRespDto>> queryByPage(@ModelAttribute PackageReqDto packageReqDto,
                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询套餐商品上下架数量
     *
     * @param packageReqDto
     * @return
     */
    @GetMapping("/counts")
    @ApiOperation(value = "查询上下架套餐数量", notes = "查询上下架套餐数量")
    RestResponse<PackageShelfCountRespDto> queryCounts(@ModelAttribute PackageReqDto packageReqDto);

    @GetMapping("/shop/{itemId}")
    @ApiOperation(value = "商品详情套餐信息", notes = "商品详情套餐信息")
    RestResponse<PackageRespDto> queryDetail(@PathVariable("itemId") Long itemId, @RequestParam("shopId") Long shopId);

    @GetMapping("/item/list")
    @ApiOperation(value = "添加的商品列表", notes = "添加的商品列表")
    RestResponse<List<PackageItemRespDto>> getPackageItemList(@RequestParam("shelfIds") String shelfIds);

    @GetMapping("/shelf/list")
    @ApiOperation(value = "上架商品数据", notes = "上架商品数据")
    RestResponse<PageInfo<PackageItemRespDto>> queryShelfPage(@ModelAttribute PackageShelfQueryReqDto packageShelfQueryReqDto,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping("/item/lists")
    @ApiOperation(value = "查询上架商品数据", notes = "查询上架商品数据")
    RestResponse<List<PackageItemRespDto>> getRPackageShelfList(@ModelAttribute PackageReqDto packageReqDto);
}
