package com.dtyunxi.yundt.cube.center.item.api.omnichannel.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.ItemRelationComparisonRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商品关系对照
 *
 * @Interface IItemRelationComparisonQueryApi
 * @Author chunjiu
 * @Date 2020/12/23 15:38
 */
@Api(tags = {"商品中心：商品关系对照"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId="com-dtyunxi-yundt-cube-center-item-api-base-query-IItemRelationComparisonQueryApi",
        path = "/v1/item/relation",
        url = "${yundt.cube.center.item.api:}")
public interface IItemRelationComparisonQueryApi {

    /**
     * 分页查询商品关系对照列表
     *
     * @param filter filter为CargoQueryReqDto对应的JSON字符串
     * @param pageNum  指定页码
     * @param pageSize 指定每页返回的对象个数
     * @return 商品关系对照表响应Dto
     **/
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询商品关系对照列表", notes = "分页查询商品关系对照列表", response = ItemRelationComparisonRespDto.class)
    RestResponse<PageInfo<ItemRelationComparisonRespDto>> queryItemRelationByPage(@RequestParam(value = "filter", required = false) String filter,
                                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询商品关系对照详情
     *
     * @param id   货品code
     * @return CargoRespDto 商品关系对照表响应Dto
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询详情")
    RestResponse<ItemRelationComparisonRespDto> queryById(@NotNull(message = "id不能为空") @PathVariable("id") Long id);

    /**
     * 查询商品关系对照列表
     * @param channelCode 渠道编码
     * @param channelItemCode 渠道商品编码
     * @param channelSkuCode 渠道商品sku编码
     * @return
     */
    @GetMapping("/queryByParam")
    @ApiOperation(value = "根据参数查询")
    RestResponse<List<ItemRelationComparisonRespDto>> queryByParam(@RequestParam(value = "channelCode", required = false) String channelCode,
                                                                   @RequestParam(value = "channelItemCode", required = false) String channelItemCode,
                                                                   @RequestParam(value = "channelSkuCode", required = false) String channelSkuCode);

}
