/**
 * @(#) IItemQueryApi.java 1.0 2018-08-22
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.omnichannel.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;

/**
 * @author chunjiui
 * @since 1.0.0
 */
@Api(tags = {"商品中心：渠道商品查询服务sync"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-ISyncChannelItemQueryApi",
        path = "/v1/item/syncChannelItem",
        url = "${yundt.cube.center.item.api:}")
public interface ISyncChannelItemQueryApi {
    /**
     * 分页查询渠道商品列表 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfo < ChannelItemRespDto>>
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询渠道商品分页列表", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<PageInfo<SyncChannelItemRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询渠道商品管理列表 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfo < ChannelItemRespDto>>
     */
    @GetMapping(value = "/itemPage")
    @ApiOperation(value = "分页查询渠道商品管理分页列表", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<PageInfo<SyncChannelItem4ItemManageRespDto>> queryByPage4ItemManage(@RequestParam(name = "filter", required = false) String filter,
                                                                                     @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询渠道商品管理列表 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @return RestResponse<PageInfo < ChannelItemRespDto>>
     */
    @GetMapping(value = "/validShops4itemPage")
    @ApiOperation(value = "分页查询渠道商品管理分页列表", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<List<ValidShops4ItemManageRespDto>> validShops4ItemManage(@RequestParam(name = "filter", required = false) String filter);

    /**
     * 分页查询渠道单个商品分页列表 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfo < ChannelItemRespDto>>
     */
    @GetMapping(value = "/singleItemPage")
    @ApiOperation(value = "分页查询渠道单个商品分页列表", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<PageInfo<SyncChannelItem4SingleItemRespDto>> queryByPage4SingleItem(@RequestParam(name = "filter", required = false) String filter,
                                                                                     @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 渠道单个商品上下架统计 filter -> ChannelItemReqDto
     *
     * @param filter   查询参数ChannelItemReqDto json对象字符串
     * @return Count4SingleItemRespDto
     */
    @GetMapping(value = "/singleItemCount")
    @ApiOperation(value = "渠道单个商品上下架统计", notes = "根据pageNum,pageSize,渠道商品Dto查询渠道商品信息,filter=ChannelItemReqDto")
    RestResponse<Count4SingleItemRespDto> count4SingleItem(@RequestParam(name = "filter", required = false) String filter);

    /**
     * 渠道商品统计
     * @param filter
     * @return
     */
    @GetMapping(value = "/page/count")
    @ApiOperation(value = "渠道商品统计", notes = "渠道商品统计")
    RestResponse<SyncChannelItemCountRespDto> count(@RequestParam(name = "filter", required = false) String filter);
}
