/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl;

import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.EPayCapitalGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.AllotResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.CancelResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.ExtractResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.PayResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.RecordResp;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.finance.FinanceResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.sms.AquireSmsResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ePayGatewayService")
public class EPayGatewayServiceImpl
implements GatewayService<EnterpriseOrderEo, RefundOrderEo, EnterpriseOrderEo>,
EPayCapitalGatewayService {
    private Logger logger = LoggerFactory.getLogger(EPayGatewayServiceImpl.class);
    @Resource
    private AbstractEPayCheckGatewayService ePayAllotOrderCheckGatewayService;
    @Resource
    private AbstractEPayCheckGatewayService ePayRecordOrderCheckGatewayService;
    @Resource
    private AbstractEPayCheckGatewayService ePayPayOrderCheckGatewayService;
    @Resource
    private AbstractEPayCheckGatewayService ePayRefundOrderCheckGatewayService;
    @Resource
    private AbstractEPayCheckGatewayService ePayExtractOrderCheckGatewayService;
    @Resource
    private EnterpriseOrderDas payEnterpriseOrderDas;
    @Resource
    private EnterpriseOrderAttachInfoDas enterpriseOrderAttachinfoDas;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, PayResp> ePayOrderComfirmGatewayService;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, PayResp> ePayOrderCreateGatewayService;
    @Resource
    private AbstractEPayGatewayService<RefundOrderEo, PayResp> ePayRefundOrderGatewayService;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, ExtractResp> ePayExtractOrderGatewayService;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, AquireSmsResp> ePayAquireSmsCodeGatewayService;
    @Resource
    private AbstractEPayGatewayService<RefundOrderEo, CancelResp> ePayOrderCancelGatewayService;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, AllotResp> ePayOrderAllotGatewayService;
    @Resource
    private AbstractEPayGatewayService<EnterpriseOrderEo, RecordResp> ePayOrderRecordGatewayService;
    @Resource
    private AbstractEPayGatewayService<PartnerConfigEo, FinanceResponse> ePayOrderDownloadGatewayService;

    public BaseGatewayResult createEnterOrder(EnterpriseOrderEo order) {
        switch (EnterOrderType.getTradeIdType((String)order.getTranType())) {
            case ALLOT: {
                return this.allotOrder(order);
            }
            case RECORD: {
                return this.allotRecordOrder(order);
            }
            case EXTRACT: {
                return this.extractOrder(order);
            }
            case PAY: {
                return this.createPayTrade(order);
            }
        }
        return this.extractOrder(order);
    }

    public CheckResult checkOrder(String tradeId) {
        if (TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.ENTERTRADE)) {
            EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
            switch (EnterOrderType.getTradeIdType((String)enterpriseOrder.getTranType())) {
                case ALLOT: {
                    return (CheckResult)this.ePayAllotOrderCheckGatewayService.execute(tradeId);
                }
                case PAY: {
                    return (CheckResult)this.ePayPayOrderCheckGatewayService.execute(tradeId);
                }
                case EXTRACT: {
                    return (CheckResult)this.ePayExtractOrderCheckGatewayService.execute(tradeId);
                }
            }
            return (CheckResult)this.ePayRecordOrderCheckGatewayService.execute(tradeId);
        }
        return (CheckResult)this.ePayRefundOrderCheckGatewayService.execute(tradeId);
    }

    public BaseGatewayResult createPayTrade(EnterpriseOrderEo order) {
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)order.getTradeId());
        if ("COMFIRM".equals(attachinfoEo.getRemark4())) {
            return this.ePayOrderComfirmGatewayService.execute(order);
        }
        return this.ePayOrderCreateGatewayService.execute(order);
    }

    public BaseGatewayResult createRefundTrade(RefundOrderEo order) {
        return this.ePayRefundOrderGatewayService.execute(order);
    }

    public BaseGatewayResult downloadTradeOrder(PartnerConfigEo partnerConfig) {
        return this.ePayOrderDownloadGatewayService.execute(partnerConfig);
    }

    public BaseGatewayResult closePayTrade(EnterpriseOrderEo order) {
        this.logger.warn("\u6682\u65f6\u4e0d\u652f\u6301\u8ba2\u5355\u901a\u77e5\uff0c\u529f\u80fd\u672a\u5b9e\u73b0");
        return new BaseGatewayResult();
    }

    public BaseGatewayResult handleNotify(Map<String, String> notify, String ntfyTradeId) throws Exception {
        this.logger.warn("\u6682\u65f6\u4e0d\u652f\u6301\u8ba2\u5355\u901a\u77e5\uff0c\u529f\u80fd\u672a\u5b9e\u73b0");
        return new BaseGatewayResult();
    }

    public BaseGatewayResult aquireSmsCode(EnterpriseOrderEo order) {
        return this.ePayAquireSmsCodeGatewayService.execute(order);
    }

    public BaseGatewayResult allotOrder(EnterpriseOrderEo order) {
        return this.ePayOrderAllotGatewayService.execute(order);
    }

    public BaseGatewayResult allotRecordOrder(EnterpriseOrderEo order) {
        return this.ePayOrderRecordGatewayService.execute(order);
    }

    public BaseGatewayResult extractOrder(EnterpriseOrderEo order) {
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)order.getTradeId());
        if ("AQ_SMS".equals(attachinfoEo.getRemark4())) {
            return this.aquireSmsCode(order);
        }
        return this.ePayExtractOrderGatewayService.execute(order);
    }

    public BaseGatewayResult cancelOrder(RefundOrderEo order) {
        return this.ePayOrderCancelGatewayService.execute(order);
    }

    public BaseGatewayResult createEnterpriseTransferOrder(EnterpriseOrderEo order) {
        return null;
    }
}

