/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital;

import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.ExtractReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.ExtractResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayExtractOrderGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayExtractOrderGatewayServiceImpl
extends AbstractEPayGatewayService<EnterpriseOrderEo, ExtractResp> {
    public BaseGatewayResult rechargeResult(EnterpriseOrderEo payOrder, ExtractResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)payOrder.getTradeId(), (String)resp.getFrontLogNo(), null);
        if ("000000".equals(resp.getRspCode())) {
            this.payEnterOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
        } else {
            partnerOrder.setErrorMsg(resp.getRspMsg());
            partnerOrder.setErrorCode(resp.getRspCode());
            if ("ERR138".equals(resp.getRspCode())) {
                this.logger.warn("\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u9519\u8bef\uff0c \u4e0d\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff01");
            } else {
                partnerOrder.setFinishTime(new Date());
                this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
            }
        }
        return this.formatEPayGwResult(payOrder.getTradeId(), resp.getRspCode(), resp.getRspMsg());
    }

    public ExtractResp _execute(EnterpriseOrderEo order) throws Exception {
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)order.getTradeId());
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)order.getPartnerConfigCode());
        ExtractReq request = new ExtractReq(config.getPtMerId(), order.getTradeId(), config.getPtAccount(), order.getUserId(), order.getPtUserId());
        request.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        request.setCustName(order.getUserName());
        request.setOutAcctIdName(order.getUserName());
        request.setHandFee(null == order.getFee() ? "0" : order.getFee().toString());
        request.setSerialNo(attachinfoEo.getRemark5());
        request.setOutAcctId(order.getPartnerAccount());
        request.setMessageCode(attachinfoEo.getRemark());
        request.setTranAmount(order.getAmount().toString());
        return this.ePayCapitalPartnerService.extractOrder(request);
    }

    public void validate(EnterpriseOrderEo payEnterpriseOrder, ExtractResp extractResp) throws Exception {
    }
}

