/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital;

import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.BatchPayReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.PayReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.capital.PayResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayOrderCreateGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayOrderCreateGatewayServiceImpl
extends AbstractEPayGatewayService<EnterpriseOrderEo, PayResp> {
    public BaseGatewayResult rechargeResult(EnterpriseOrderEo order, PayResp resp) throws Exception {
        this.parseOrderResult(order, resp);
        List subOrders = this.payEnterpriseOrderDas.selectByParentTradeId(order.getTradeId());
        if (CollectionUtils.isNotEmpty((Collection)subOrders)) {
            for (EnterpriseOrderEo subOrder : subOrders) {
                this.parseOrderResult(subOrder, resp);
            }
        }
        return this.formatEPayGwResult(order.getTradeId(), resp.getRspCode(), resp.getRspMsg());
    }

    private void parseOrderResult(EnterpriseOrderEo order, PayResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)order.getTradeId(), (String)resp.getFrontLogNo(), (Date)new Date());
        if ("000000".equals(resp.getRspCode())) {
            this.payEnterOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
        } else {
            partnerOrder.setErrorCode(resp.getRspCode());
            partnerOrder.setErrorMsg(resp.getRspMsg());
            this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
    }

    public PayResp _execute(EnterpriseOrderEo order) throws Exception {
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)order.getTradeId());
        if ("PARENT_ORDER".equals(attachinfoEo.getRemark3())) {
            return this.ePayCapitalPartnerService.batchPay(this.packageBatchPayReq(order));
        }
        return (PayResp)this.ePayCapitalPartnerService.placeOrder((Object)this.packagePayReq(order));
    }

    public void validate(EnterpriseOrderEo payEnterpriseOrder, PayResp payResp) throws Exception {
    }

    private BatchPayReq packageBatchPayReq(EnterpriseOrderEo order) {
        BatchPayReq payReq = new BatchPayReq();
        payReq.setOutCustAcctId(order.getPtUserId());
        payReq.setOutThirdCustId(order.getUserId());
        PartnerConfigEo partnerConfig = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)order.getPartnerConfigCode());
        payReq.setSupAcctId(partnerConfig.getPtAccount());
        payReq.setQydm(partnerConfig.getPtMerId());
        List subOrders = this.payEnterpriseOrderDas.selectByParentTradeId(order.getTradeId());
        for (EnterpriseOrderEo subOrder : subOrders) {
            EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)subOrder.getTradeId());
            payReq.addPayInfo(subOrder.getTradeId(), attachinfoEo.getRemark1(), attachinfoEo.getRemark2(), subOrder.getAmount(), subOrder.getFee());
        }
        payReq.setThirdLogNo(order.getTradeId());
        return payReq;
    }

    private PayReq packagePayReq(EnterpriseOrderEo order) {
        PayReq payReq = new PayReq();
        PartnerConfigEo partnerConfig = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)order.getPartnerConfigCode());
        payReq.setSupAcctId(partnerConfig.getPtAccount());
        payReq.setQydm(partnerConfig.getPtMerId());
        payReq.setThirdLogNo(order.getTradeId());
        List subOrders = this.payEnterpriseOrderDas.selectByParentTradeId(order.getTradeId());
        EnterpriseOrderEo subOrder = (EnterpriseOrderEo)subOrders.get(0);
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)subOrder.getTradeId());
        payReq.setOutCustAcctId(subOrder.getPtUserId());
        payReq.setOutThirdCustId(subOrder.getUserId());
        payReq.setOutCustName(subOrder.getUserName());
        payReq.setInCustName(attachinfoEo.getRemark4());
        payReq.setInCustAcctId(attachinfoEo.getRemark2());
        payReq.setInThirdCustId(attachinfoEo.getRemark1());
        payReq.setTranAmount(subOrder.getAmount().toString());
        payReq.setTranFee(subOrder.getFee().toString());
        payReq.setThirdHtId(subOrder.getTradeId());
        return payReq;
    }
}

