/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.capital.query;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.impl.AbstractEPayCheckGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.QueryOrderResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ePayAllotOrderCheckGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class EPayAllotOrderCheckGatewayServiceImpl
extends AbstractEPayCheckGatewayService {
    @Override
    public QueryOrderReq getQueryReq(String tradeId) throws Exception {
        EnterpriseOrderEo order = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
        QueryOrderReq request = this.initQueryReq(order.getPartnerAccount(), order.getTradeId(), order.getPartnerConfigCode());
        request.setTranDate(new DateTime((Object)order.getOrderTime()).toString("yyyyMMdd"));
        request.setFuncFlag(AbstractEPayCheckGatewayService.FuncFlag.RECHARGE.getFlag());
        return request;
    }

    @Override
    public void rechargeResponse(String tradeId, QueryOrderResp resp) throws Exception {
        EnterpriseOrderEo partnerOrder = OrderAssistant.createEnterOrder((String)tradeId, (Date)new Date());
        partnerOrder.setAcceptTime(new Date());
        if ("000000".equals(resp.getRspCode())) {
            if (AbstractEPayCheckGatewayService.TranStatus.SUCC.getStatus().equals(resp.getTranStatus())) {
                this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u6210\u529f");
                partnerOrder.setAmount(new BigDecimal(resp.getTranAmount()));
                this.payEnterOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            } else {
                RefundOrderEo example = RefundOrderEo.newInstance();
                example.setTradeId(partnerOrder.getTradeId());
                List refundOrders = this.payRefundOrderDas.select((BaseEo)example);
                if (null != refundOrders && !refundOrders.isEmpty() && AbstractEPayCheckGatewayService.TranStatus.FAIL.getStatus().equals(resp.getTranStatus())) {
                    this.logger.warn("\u8ba2\u5355\u5df2\u64a4\u9500\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u8be5\u8ba2\u5355\u72b6\u6001");
                } else {
                    this.logger.info("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u5931\u8d25, \u672c\u5730\u4e0d\u5b58\u5728\u9000\u6b3e\u8ba2\u5355");
                    partnerOrder.setErrorCode(resp.getRspCode());
                    partnerOrder.setErrorMsg(resp.getRspMsg());
                    this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
                }
            }
        } else if ("ERR020".equals(resp.getRspCode())) {
            this.logger.error("\u6e20\u9053\u54cd\u5e94\u8ba2\u5355\u4e0d\u5b58\u5728");
            partnerOrder.setErrorCode(resp.getRspCode());
            partnerOrder.setErrorMsg(resp.getRspMsg());
            this.payEnterOrderProcessorService.handleFailOrder((Object)partnerOrder);
        } else {
            this.logger.error("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u9519\u8bef\u7801\u4e3a\uff1a" + resp.getRspCode());
        }
    }

    public void validate(String tradeId, QueryOrderResp queryOrderResp) throws Exception {
    }
}

